<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin\Assignments;
use App\Models\Admin\Courses;
use App\Models\Admin\EducationalSessions;
use App\Models\Admin\Projects;
use App\Models\Admin\Subjects;
use App\Models\Customers;
use App\Models\Files;
use App\Models\Modules;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class DataController extends Controller
{
    public function manageGuestData()
    {
        $modules = Modules::select('id', 'email_to', 'your_email', 'passcode', 'sharable_link', 'message', 'total_clicks', 'validity', 'status')->orderByDesc('id')->where('customer_id', 0)->get();
        foreach ($modules as $module) {
            $module->encrypted_id = Crypt::encrypt($module->id);
            $module->is_valid = $module->validity && Carbon::parse($module->validity, 'Asia/Kolkata')->isPast() ? 'Invalid' : 'Valid';
        }

        $currentPage = "manage_guest_users_data";
        return view('admin.manage_users_data', ['modulesData' => $modules, 'currentPage' => $currentPage]);
    }

    public function viewFiles(Request $request)
    {
        $module_id = Crypt::decrypt($request->module_id);
        $currentPage = "manage_guest_users_data";
        $customer = null;
        if (isset($request->customer_enc) && !empty($request->customer_enc)) {
            $customer_id = Crypt::decrypt($request->customer_enc);
            $customer = Customers::find($customer_id);
            $customer->encrypted_id = $request->customer_enc;
            $currentPage = "manage_customers";
        }
        $files = Files::select('id', 'original_name', 'encrypted_name', 'total_downloads', 'file_status')->where('module_id', $module_id)->orderByDesc('id')->get();
        foreach ($files as $file) {
            $file->encrypted_id = Crypt::encrypt($file->id);
        }

        return view('admin.view_files_data', ['customer' => $customer, 'filesData' => $files, 'currentPage' => $currentPage]);
    }

    public function getCourseCsvData()
    {
        $path = public_path('data/ignou_course.csv');

        if (! file_exists($path)) {
            return "CSV file not found.";
        }

        $rows = [];

        /*
        |--------------------------------------------------------------------------
        | 2️⃣ READ ASSIGNMENT CSV
        |--------------------------------------------------------------------------
        */

        if (($handle = fopen($path, 'r')) !== false) {

            $headers = fgetcsv($handle, 1000, ',');

            while (($row = fgetcsv($handle, 1000, ',')) !== false) {

                if ($row === [null] || $row === false) {
                    continue;
                }

                $row = array_pad($row, count($headers), null);
                $row = array_slice($row, 0, count($headers));

                $row = array_combine($headers, $row);

                $rows[] = $row;
            }

            fclose($handle);
        }

        // // get only the course_type column
        // $types = array_column($rows, 'course_type');

        // // keep only unique values
        // $uniqueTypes = array_unique($types);

        // // re-index and print
        // dd(array_values($uniqueTypes));

        /*
        |--------------------------------------------------------------------------
        | 3️⃣ FILTER
        |--------------------------------------------------------------------------
        */

        // $filtered = array_filter($rows, function ($row) {
        //     return ($row['assignment_type'] ?? null) === 'Solved_PDF' &&
        //         ($row['assignment_language'] ?? null) === 'English';
        // });

        // transform
        $transformed = array_map(function ($row) {

            $row['category_id'] = match ($row['course_type'] ?? null) {
                'Bachelor Degree'      => 2,
                'Master Degree'        => 3,
                'P_G_Diploma'          => 6,
                'Diploma'              => 5,
                'certificate_Diploma'  => 4,
                default                => null
            };

            return $row;
        }, $rows);

        // prepare only fields your table needs
        $insertData = [];
        $position_order = Courses::max('position_order') ?? 0;

        foreach ($transformed as $row) {

            if (!($row['course_code'] ?? null)) {
                continue; // skip invalid row
            }

            // avoid duplicate insert (based on course_code)
            if (Courses::where('course_code', $row['course_code'])->exists()) {
                continue;
            }

            $position_order++;

            $insertData[] = [
                'id'  => $row['id'],
                'category_id'  => $row['category_id'] ?? null,
                'position_order'  => $position_order,
                'course_icon'  => 'fa-folder-open',
                'course_name'  => $row['course_title'] ?? null,
                'course_headline'  => $row['site_title'] ?? null,
                'course_code'  => $row['course_code'] ?? null,
                'breadcrumb_headline'  => $row['site_title'] ?? null,
                'course_duration'    => ($row['course_in_year'] ?? null) === ''
                    ? null
                    : $row['course_in_year'],

                'course_semester'    => ($row['course_semester'] ?? null) === ''
                    ? null
                    : $row['course_semester'],
                'meta_title'  => $row['site_title'] ?? null,
                'meta_keyword'  => $row['meta_tags'] ?? null,
                'meta_description'  => htmlspecialchars($row['meta_description'], ENT_QUOTES) ?? null,
            ];
        }

        // echo '<pre>';
        // print_r(array_values($insertData));
        // echo '</pre>';

        // chunk insert (fast)
        foreach (array_chunk($insertData, 500) as $chunk) {
            Courses::insert($chunk);
        }

        return "Imported: " . count($insertData) . " courses.";

        // echo '<pre>';
        // print_r(array_values($transformed));
        // echo '</pre>';
    }

    public function getSubjectCsvData()
    {
        $path = public_path('data/ignou_subject.csv');

        if (! file_exists($path)) {
            return "CSV file not found.";
        }

        $rows = [];

        /*
        |--------------------------------------------------------------------------
        | 2️⃣ READ ASSIGNMENT CSV
        |--------------------------------------------------------------------------
        */

        if (($handle = fopen($path, 'r')) !== false) {

            $headers = fgetcsv($handle, 1000, ',');

            while (($row = fgetcsv($handle, 1000, ',')) !== false) {

                if ($row === [null] || $row === false) {
                    continue;
                }

                $row = array_pad($row, count($headers), null);
                $row = array_slice($row, 0, count($headers));

                $row = array_combine($headers, $row);

                $rows[] = $row;
            }

            fclose($handle);
        }

        // prepare only fields your table needs
        $insertData = [];
        $position_order = Subjects::max('position_order') ?? 0;

        foreach ($rows as $row) {

            if (!($row['subject_code'] ?? null)) {
                continue; // skip invalid row
            }

            // avoid duplicate insert (based on subject_code)
            if (Subjects::where('subject_code', $row['subject_code'])->exists()) {
                continue;
            }

            $position_order++;

            $course_ids = array_filter(
                array_map('intval', explode(',', $row['course_id'] ?? ''))
            );
            $course_sems = explode(",", $row['course_sem'] ?? '');

            $insertData[] = [
                'id'  => $row['id'],
                'position_order'  => $position_order,
                'subject_name'  => $row['subject_name'] ?? null,
                'subject_code'  => $row['subject_code'] ?? null,
                'course_year'  => $row['course_year'] ?? null,
                'course_ids'  => json_encode($course_ids),
                'semesters'  => json_encode($course_sems),
                'status'  => 'active',
            ];
        }

        // echo '<pre>';
        // print_r(array_values($insertData));
        // echo '</pre>';
        // die;

        // chunk insert (fast)
        foreach (array_chunk($insertData, 300) as $chunk) {
            Subjects::insert($chunk);
        }

        return "Imported: " . count($insertData) . " Subjects.";

        // echo '<pre>';
        // print_r(array_values($transformed));
        // echo '</pre>';
    }


    public function checkAssignmentLink($assignment_url, $encrypted_id = "")
    {
        $assignment_url = str_replace(['/', ' '], '-', $assignment_url);
        $assignment_url = preg_replace('/[^a-z0-9-]+/', '-', $assignment_url);
        $assignment_url = trim($assignment_url, '-');
        $assignment_url = preg_replace('/-+/', '-', $assignment_url);
        $original_link = $assignment_url;

        // $id = (isset($encrypted_id) && !empty($encrypted_id)) ? Crypt::decrypt($encrypted_id) : 0;
        // $suffix = 1;
        // do {
        //     $count = $id != 0 ? Assignments::where('assignment_url', $assignment_url)->where('id', '!=', $id)->count() : Assignments::where('assignment_url', $assignment_url)->count();

        //     if ($count > 0) {
        //         $assignment_url = $original_link . '-' . $suffix;
        //         $suffix++;
        //     } else {
        //         break;
        //     }
        // } while (true);

        return $assignment_url;
    }

    public function getAssignmentCsvData()
    {
        $path = public_path('data/ignou_assignment.csv');

        if (! file_exists($path)) {
            return "CSV file not found.";
        }

        $rows = [];

        /*
        |--------------------------------------------------------------------------
        | 2️⃣ READ ASSIGNMENT CSV
        |--------------------------------------------------------------------------
        */

        if (($handle = fopen($path, 'r')) !== false) {

            $headers = fgetcsv($handle, 1000, ',');

            while (($row = fgetcsv($handle, 1000, ',')) !== false) {

                if ($row === [null] || $row === false) {
                    continue;
                }

                $row = array_pad($row, count($headers), null);
                $row = array_slice($row, 0, count($headers));

                $row = array_combine($headers, $row);

                // extract assignment_code
                $assignmentCode = null;

                if (! empty($row['alt_tag'])) {
                    $parts = explode(' - ', $row['alt_tag']);
                    $assignmentCode = trim($parts[0]);
                }

                $row['assignment_code'] = $assignmentCode;

                $rows[] = $row;
            }

            fclose($handle);
        }

        // // get only the assignment_type column
        // $types = array_column($rows, 'assignment_type');

        // // keep only unique values
        // $uniqueTypes = array_unique($types);

        // // re-index and print
        // dd(array_values($uniqueTypes));

        // Result
        // array:4 [▼ // app\Http\Controllers\Admin\DataController.php:308
        //     0 => "project"
        //     1 => "Solved_PDF"
        //     2 => null
        //     3 => "handwritten"
        // ]

        // get only the assignment_language column
        // $languages = array_column($rows, 'assignment_language');

        // // keep only unique values
        // $uniqueLanguages = array_unique($languages);

        // // re-index and print
        // dd(array_values($uniqueLanguages));

        // Result
        // array:6 [▼ // app\Http\Controllers\Admin\DataController.php:317
        //     0 => "English"
        //     1 => "Hindi"
        //     2 => null
        //     3 => "Urdu"
        //     4 => "Panjabi"
        //     5 => "Sanskrit"
        // ]

        // // get only the assignment_code column
        // $codes = array_column($rows, 'assignment_code');

        // // keep only unique values
        // $uniqueCodes = array_unique($codes);

        // // re-index and print
        // dd(array_values($uniqueCodes));

        /*
        |--------------------------------------------------------------------------
        | 3️⃣ FILTER
        |--------------------------------------------------------------------------
        */

        $filtered = array_filter($rows, function ($row) {
            return ($row['assignment_type'] ?? null) === 'handwritten';
            // return ($row['assignment_type'] ?? null) === 'Solved_PDF';
            // return ($row['assignment_type'] ?? null) === 'Solved_PDF' && ($row['assignment_language'] ?? null) === 'English';
        });

        // transform
        $transformed = array_map(function ($row) {
            $row['language_ids'] = [];

            if (($row['assignment_type'] ?? null) === 'handwritten') {
                $row['assignment_type'] = 'handwritten';
            }

            $lang = $row['assignment_language'] ?? null;

            $map = [
                'English'  => 1,
                'Hindi'    => 2,
                'Urdu'     => 3,
                'Panjabi'  => 4,
                'Sanskrit' => 5,
            ];

            if (isset($map[$lang])) {
                $row['language_ids'] = [$map[$lang]];   // 👈 always array
            }

            $row['type_ids'] = [2];

            return $row;
        }, $filtered);

        // echo '<pre>';
        // echo "Imported: " . count($transformed) . " assignments.";
        // print_r(array_values($transformed));
        // echo '</pre>';
        // die;

        $months = '(January|February|March|April|May|June|July|August|September|October|November|December|Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Sept|Oct|Nov|Dec)';

        $normalizeSession = function ($value) use ($months) {

            if (! $value) return null;

            $value = str_replace(['–', '—'], '-', $value);

            // capture ALL month-year occurrences
            if (preg_match_all("/$months\\s+\\d{2,4}/i", $value, $matches)) {

                $dates = $matches[0];

                if (count($dates) === 1) {
                    return $dates[0];
                }

                return $dates[0] . ' - ' . $dates[count($dates) - 1];
            }

            return trim($value);
        };

        $all_dynamic_sessions = EducationalSessions::select('id', 'session_name')->get();
        $sessionMap = $all_dynamic_sessions
            ->pluck('id', 'session_name')
            ->toArray();

        // prepare only fields your table needs
        $insertData = [];
        $position_order = Assignments::max('position_order') ?? 0;

        foreach ($transformed as $row) {

            if (!($row['assignment_code'] ?? null)) {
                continue; // skip invalid row
            }

            // // avoid duplicate insert (based on assignment_code)
            // if (Assignments::where('assignment_code', $row['assignment_code'])->exists()) {
            //     continue;
            // }

            $position_order++;

            $rawSession   = $row['session'] ?? null;
            $cleanSession = $normalizeSession($rawSession);
            $sessionId    = $sessionMap[$cleanSession] ?? null;

            $insertData[] = [
                'id'  => $row['id'],
                'subject_id'  => $row['subject_id'],
                'type_ids'  => json_encode($row['type_ids']),
                'language_ids'  => json_encode($row['language_ids']),
                'session_ids'  => json_encode($sessionId ? [$sessionId] : []),
                'position_order'  => $position_order,
                'assignment_type'  => $row['assignment_type'] ?? null,
                'assignment_code'  => $row['assignment_code'] ?? null,
                'assignment_url'  => $this->checkAssignmentLink(strtolower($row['assignment_code']) ?? null),
                'assignment_subject_name'  => $row['page_title'] ?? null,
                'assignment_title'  => $row['page_title'] ?? null,
                'breadcrumb_headline'  => $row['page_title'] ?? null,
                'maximum_retail_price'    => $row['mrp_price'],
                'selling_price'    => $row['final_price'],
                'discount'    => 50,
                'additional_discount'    => 0,
                'assignment_quantity'    => 10,
                'assignment_image'    => 'images/assignments/' . $row['th_image'],
                'question_paper_image'    => 'images/assignments/' . $row['snapshot'],

                'short_description'    => '&lt;p&gt;IGNOU students must submit the assignment timely as it impacts the final grades. Every academic session has specific deadlines and if you miss these set dates, you may face penalties from the university. Stay updated until the official IGNOU publications so that you know the last date for submission.&lt;/p&gt;',

                'download_info'    => '&lt;h5&gt;Download your IGNOU Solved assignment PDF Instantly &amp;mdash; No Waiting, No Hassle!&lt;/h5&gt;&lt;p&gt;The moment your payment is completed and successful, the BCHCT-135 solved assignment PDF will be available for immediate download. No waiting &amp;mdash; access your assignment using any device:&lt;/p&gt;&lt;p&gt;Download your assignment now and don&#039;t risk the stress of your last-minute panic!&lt;/p&gt;',

                'description'    => '&lt;p class=&quot;text-secondary mb-2&quot;&gt;Looking for a ready-to-use and marks-boosting solved assignment for &lt;strong&gt; BCHCT-135 Solutions, Phase Equilibrium, Conductance, Electrochemistry And Functional Group Organic Chemistry-II&lt;/strong&gt;? This assignment is prepared strictly as per the latest IGNOU guidelines for the January 2024, December 2024, January 2025 and December 2025 sessions (English Medium).&lt;/p&gt;&lt;p class=&quot;text-secondary mb-0&quot;&gt;It is ideal for B.Sc. students who want accuracy, clarity, and quick access. This high-quality solved assignment helps you score better with minimal effort.&lt;/p&gt;',

                'cover_page_info'    => '&lt;h5&gt;IGNOU Assignment Cover Page Format: A Complete Guide to Clear Your Confusion with Instant PDF Download&lt;/h5&gt;&lt;p&gt;Don&amp;rsquo;t risk rejection &amp;mdash; access our step-by-step IGNOU cover page guide with a ready-to-fill format, perfectly aligned with the latest university guidelines&lt;/p&gt;',

                'meta_title'  => $row['page_title'] ?? null,
                'meta_keyword'  => $row['meta_tags'] ?? null,
                'meta_description'  => htmlspecialchars($row['meta_description'], ENT_QUOTES) ?? null,
            ];
        }

        // echo '<pre>';
        // echo "Imported: " . count($transformed) . " assignments.";
        // print_r(array_values($transformed));
        // echo '</pre>';
        // die;
        // dd($insertData);

        echo '<pre>';
        echo "Imported: " . count($insertData) . " assignments.";
        print_r(array_values($insertData));
        echo '</pre>';
        die;

        // chunk insert (fast)
        foreach (array_chunk($insertData, 300) as $chunk) {
            Assignments::insert($chunk);
        }

        return "Imported: " . count($insertData) . " assignments.";

        // echo '<pre>';
        // print_r(array_values($transformed));
        // echo '</pre>';
    }


    public function checkProjectLink($project_url, $encrypted_id = "")
    {
        $project_url = str_replace(['/', ' '], '-', $project_url);
        $project_url = preg_replace('/[^a-z0-9-]+/', '-', $project_url);
        $project_url = trim($project_url, '-');
        $project_url = preg_replace('/-+/', '-', $project_url);
        $original_link = $project_url;

        // $id = (isset($encrypted_id) && !empty($encrypted_id)) ? Crypt::decrypt($encrypted_id) : 0;
        // $suffix = 1;
        // do {
        //     $count = $id != 0 ? Projects::where('project_url', $project_url)->where('id', '!=', $id)->count() : Projects::where('project_url', $project_url)->count();

        //     if ($count > 0) {
        //         $project_url = $original_link . '-' . $suffix;
        //         $suffix++;
        //     } else {
        //         break;
        //     }
        // } while (true);

        return $project_url;
    }

    public function getProjectCsvData()
    {
        $path = public_path('data/ignou_assignment.csv');

        if (! file_exists($path)) {
            return "CSV file not found.";
        }

        $rows = [];

        /*
        |--------------------------------------------------------------------------
        | 2️⃣ READ ASSIGNMENT CSV
        |--------------------------------------------------------------------------
        */

        if (($handle = fopen($path, 'r')) !== false) {

            $headers = fgetcsv($handle, 1000, ',');

            while (($row = fgetcsv($handle, 1000, ',')) !== false) {

                if ($row === [null] || $row === false) {
                    continue;
                }

                $row = array_pad($row, count($headers), null);
                $row = array_slice($row, 0, count($headers));

                $row = array_combine($headers, $row);

                // extract project_code
                $assignmentCode = null;

                if (! empty($row['alt_tag'])) {
                    $parts = explode(' - ', $row['alt_tag']);
                    $assignmentCode = trim($parts[0]);
                }

                $row['project_code'] = $assignmentCode;

                $rows[] = $row;
            }

            fclose($handle);
        }

        // // get only the assignment_type column
        // $types = array_column($rows, 'assignment_type');

        // // keep only unique values
        // $uniqueTypes = array_unique($types);

        // // re-index and print
        // dd(array_values($uniqueTypes));

        // Result
        // array:4 [▼ // app\Http\Controllers\Admin\DataController.php:308
        //     0 => "project"
        //     1 => "Solved_PDF"
        //     2 => null
        //     3 => "handwritten"
        // ]

        // get only the assignment_language column
        // $languages = array_column($rows, 'assignment_language');

        // // keep only unique values
        // $uniqueLanguages = array_unique($languages);

        // // re-index and print
        // dd(array_values($uniqueLanguages));

        // Result
        // array:6 [▼ // app\Http\Controllers\Admin\DataController.php:317
        //     0 => "English"
        //     1 => "Hindi"
        //     2 => null
        //     3 => "Urdu"
        //     4 => "Panjabi"
        //     5 => "Sanskrit"
        // ]

        // // get only the project_code column
        // $codes = array_column($rows, 'project_code');

        // // keep only unique values
        // $uniqueCodes = array_unique($codes);

        // // re-index and print
        // dd(array_values($uniqueCodes));

        /*
        |--------------------------------------------------------------------------
        | 3️⃣ FILTER
        |--------------------------------------------------------------------------
        */

        $filtered = array_filter($rows, function ($row) {
            return ($row['assignment_type'] ?? null) === 'project';
        });

        // transform
        $transformed = array_map(function ($row) {
            $row['language_ids'] = [];

            $lang = $row['assignment_language'] ?? null;

            $map = [
                'English'  => 1,
                'Hindi'    => 2,
                'Urdu'     => 3,
                'Panjabi'  => 4,
                'Sanskrit' => 5,
            ];

            if (isset($map[$lang])) {
                $row['language_ids'] = [$map[$lang]];   // 👈 always array
            }

            $row['type_ids'] = [2];

            return $row;
        }, $filtered);

        // echo '<pre>';
        // echo "Imported: " . count($transformed) . " assignments.";
        // print_r(array_values($transformed));
        // echo '</pre>';
        // die;

        $months = '(January|February|March|April|May|June|July|August|September|October|November|December|Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Sept|Oct|Nov|Dec)';

        $normalizeSession = function ($value) use ($months) {

            if (! $value) return null;

            $value = str_replace(['–', '—'], '-', $value);

            // capture ALL month-year occurrences
            if (preg_match_all("/$months\\s+\\d{2,4}/i", $value, $matches)) {

                $dates = $matches[0];

                if (count($dates) === 1) {
                    return $dates[0];
                }

                return $dates[0] . ' - ' . $dates[count($dates) - 1];
            }

            return trim($value);
        };

        $all_dynamic_sessions = EducationalSessions::select('id', 'session_name')->get();
        $sessionMap = $all_dynamic_sessions
            ->pluck('id', 'session_name')
            ->toArray();

        // prepare only fields your table needs
        $insertData = [];
        $position_order = Projects::max('position_order') ?? 0;
        $reference_number = Projects::max('reference_number') ?? 100;

        foreach ($transformed as $row) {

            if (!($row['project_code'] ?? null)) {
                continue; // skip invalid row
            }

            // // avoid duplicate insert (based on project_code)
            // if (Projects::where('project_code', $row['project_code'])->exists()) {
            //     continue;
            // }

            $position_order++;
            $reference_number++;

            $rawSession   = $row['session'] ?? null;
            $cleanSession = $normalizeSession($rawSession);
            $sessionId    = $sessionMap[$cleanSession] ?? null;

            $insertData[] = [
                'id'  => $row['id'],
                'subject_id'  => $row['subject_id'],
                'type_ids'  => json_encode($row['type_ids']),
                'language_ids'  => json_encode($row['language_ids']),
                'session_ids'  => json_encode($sessionId ? [$sessionId] : []),
                'position_order'  => $position_order,
                'reference_number'  => $reference_number,
                'project_code'  => $row['project_code'] ?? null,
                'project_title'  => $row['projects_title'] ?? null,
                'project_url'  => $this->checkProjectLink(strtolower($row['project_code']) ?? null),
                'breadcrumb_headline'  => $row['page_title'] ?? null,
                'maximum_retail_price'    => $row['mrp_price'],
                'selling_price'    => $row['final_price'],
                'discount'    => 50,
                'additional_discount'    => 0,
                'project_quantity'    => 10,
                'project_image'    => 'images/projects/' . $row['th_image'],
                'demo_file'    => 'images/projects/demo/' . $row['demo_pdf'],
                'project_file'    => 'images/projects/files/' . $row['final_file'],
                'question_paper_image'    => (!empty($row['snapshot']) && $row['snapshot'] !== 'NULL') ? 'images/projects/' . $row['snapshot'] : null,
                'file_password'    => $row['file_pass'],

                'short_description'    => '&lt;p&gt;IGNOU students must submit the project timely as it impacts the final grades. Every academic session has specific deadlines and if you miss these set dates, you may face penalties from the university. Stay updated until the official IGNOU publications so that you know the last date for submission.&lt;/p&gt;',

                'download_info'    => '&lt;h5&gt;Download your IGNOU Project PDF Instantly &amp;mdash; No Waiting, No Hassle!&lt;/h5&gt;&lt;p&gt;The moment your payment is completed and successful, the BCHCT-135 project PDF will be available for immediate download. No waiting &amp;mdash; access your project using any device:&lt;/p&gt;&lt;p&gt;Download your project now and don&#039;t risk the stress of your last-minute panic!&lt;/p&gt;',

                'description'    => '&lt;p class=&quot;text-secondary mb-2&quot;&gt;Looking for a ready-to-use and marks-boosting project for &lt;strong&gt; BCHCT-135 Solutions, Phase Equilibrium, Conductance, Electrochemistry And Functional Group Organic Chemistry-II&lt;/strong&gt;? This project is prepared strictly as per the latest IGNOU guidelines for the January 2024, December 2024, January 2025 and December 2025 sessions (English Medium).&lt;/p&gt;&lt;p class=&quot;text-secondary mb-0&quot;&gt;It is ideal for B.Sc. students who want accuracy, clarity, and quick access. This high-quality project helps you score better with minimal effort.&lt;/p&gt;',

                'cover_page_info'    => '&lt;h5&gt;IGNOU Project Cover Page Format: A Complete Guide to Clear Your Confusion with Instant PDF Download&lt;/h5&gt;&lt;p&gt;Don&amp;rsquo;t risk rejection &amp;mdash; access our step-by-step IGNOU cover page guide with a ready-to-fill format, perfectly aligned with the latest university guidelines&lt;/p&gt;',

                'meta_title'  => $row['page_title'] ?? null,
                'meta_keyword'  => $row['meta_tags'] ?? null,
                'meta_description'  => htmlspecialchars($row['meta_description'], ENT_QUOTES) ?? null,
            ];
        }

        // echo '<pre>';
        // echo "Imported: " . count($transformed) . " projects.";
        // print_r(array_values($transformed));
        // echo '</pre>';
        // die;
        // dd($insertData);

        echo '<pre>';
        echo "Imported: " . count($insertData) . " projects.";
        print_r(array_values($insertData));
        echo '</pre>';
        die;

        // chunk insert (fast)
        foreach (array_chunk($insertData, 300) as $chunk) {
            Projects::insert($chunk);
        }

        return "Imported: " . count($insertData) . " projects.";

        // echo '<pre>';
        // print_r(array_values($transformed));
        // echo '</pre>';
    }
}
