<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin\FreeDownloads;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class FreeDownloadsController extends Controller
{
    public function manageFreeDownloads()
    {
        $free_downloads = FreeDownloads::select('id', 'position_order', 'file_type', 'file_name', 'file_on_top_banner', 'status')->orderBy('position_order')->get();
        foreach ($free_downloads as $free_download) {
            $free_download->encrypted_id = Crypt::encrypt($free_download->id);
        }
        $model = Crypt::encrypt('FreeDownloads');
        $currentPage = "manage_free_downloads";
        return view('admin.manage_free_downloads', ['freeDownloadsData' => $free_downloads, 'model' => $model, "currentPage" => $currentPage]);
    }

    public function addFreeDownload(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'file_type' => 'required|string',
                'file_name' => 'required|string',
                'file' => 'required|mimes:pdf',
            ], [
                'file_type.required' => 'File Type is required.',
                'file_type.string' => 'File Type should be string.',
                'file_name.required' => 'File Name is required.',
                'file_name.string' => 'File Name should be string.',
                'file.required' => 'Please upload a file.',
                'file.mimes' => 'Allowed file formats: pdf.',
            ]);

            $order = FreeDownloads::max('position_order');
            $position_order = ($order !== null) ? $order + 1 : 1;

            $file_data = [
                'position_order' => $position_order,
                'file_type' => $request->file_type,
                'file_name' => $request->file_name,
                'file_on_top_banner' => $request->file_on_top_banner ?? null,
            ];

            $path = 'images/free-downloads/';
            $filePath = $this->storeImage($request->file('file'), $path);
            $file_data['file'] = $filePath;

            if (FreeDownloads::create($file_data)) {
                $request->session()->flash('success', 'Free Download File is inserted Successfully!');
                return redirect()->route('manage.free.downloads');
            } else {
                $request->session()->flash('error', 'Insertion Error!');
                return redirect()->route('add.free.download');
            }
        } else {
            $currentPage = "manage_free_downloads";
            return view('admin.free-download-ops', ["currentPage" => $currentPage]);
        }
    }

    public function editFreeDownload(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'file_type' => 'required|string',
                'file_name' => 'required|string',
                'file' => 'mimes:pdf',
            ], [
                'file_type.required' => 'File Type is required.',
                'file_type.string' => 'File Type should be string.',
                'file_name.required' => 'File Name is required.',
                'file_name.string' => 'File Name should be string.',
                'file.mimes' => 'Allowed file formats: pdf.',
            ]);

            $id = Crypt::decrypt($request->free_download);
            $file_data = FreeDownloads::findOrFail($id);
            $file_data->file_type = $request->file_type;
            $file_data->file_name = $request->file_name;
            $file_data->file_on_top_banner = $request->file_on_top_banner ?? null;

            if (!empty($request->file('file'))) {
                $path = 'images/free-downloads/';
                $filePath = $this->storeImage($request->file("file"), $path, $file_data->file);
                $file_data->file = $filePath;
            }

            if ($file_data->save()) {
                $request->session()->flash('success', 'Free Download File is updated Successfully!');
                return redirect()->route('manage.free.downloads');
            } else {
                $request->session()->flash('error', 'Updation Error!');
                return redirect()->route('edit.free.download', $request->free_download);
            }
        } else {
            $id = Crypt::decrypt($request->free_download);
            $free_download = FreeDownloads::where('id', $id)->firstOrFail();
            $free_download->encrypted_id = $request->free_download;

            $currentPage = "manage_free_downloads";
            return view('admin.free-download-ops', ["free_download" => $free_download, "currentPage" => $currentPage]);
        }
    }
}
