<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

abstract class Controller
{
    public function removeImage($existed_file_path)
    {
        if (!empty($existed_file_path) && file_exists($existed_file_path)) {
            unlink($existed_file_path);
        }
        return;
    }

    public function storeImage($file, $path, $existed_file = "", $customFileName = null)
    {
        if (!empty($existed_file)) {
            $fullPath = public_path($existed_file);
            $this->removeImage($fullPath);
        }

        if ($customFileName) {
            $fileName = $customFileName;
        } else {
            $fileName = time() . '_' . uniqid() . '.' . $file->getClientOriginalExtension();
        }

        $filePath = $path . $fileName;
        $fullFilePath = public_path($path);
        $file->move($fullFilePath, $fileName);
        return $filePath;
    }
}
