<?php

namespace App\Mail;

use App\Models\Invoices;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Attachment;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Storage;

class CustomerInvoiceMail extends Mailable
{
    use Queueable, SerializesModels;

    public $invoice;
    public $downloadLink;

    /**
     * Create a new message instance.
     */
    public function __construct(Invoices $invoice, $downloadLink)
    {
        $this->invoice = $invoice;
        $this->downloadLink = $downloadLink;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Customer Invoice Mail',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.invoice',
            with: [
                'invoice' => $this->invoice,
                'downloadLink' => $this->downloadLink,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, Attachment>
     */
    public function attachments(): array
    {
        if ($this->invoice->file_path && Storage::disk('public')->exists($this->invoice->file_path)) {
            return [
                Attachment::fromPath(storage_path('app/public/' . $this->invoice->file_path))
                    ->as($this->invoice->invoice_number . '.pdf')
                    ->withMime('application/pdf'),
            ];
        }

        return [];
    }
}
