<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssignmentFiles extends Model
{
    use HasFactory;

    protected $table = 'assignment_files';

    protected $fillable = [
        'assignment_id',
        'type_id',
        'language_id',
        'session_id',
        'position_order',
        'file_index',
        'file_name',
        'file_path',
        'file_full_path',
        'is_protected',
        'file_price',
        'file_password',
        'status'
    ];

    protected $casts = [
        'id' => 'integer',
        'assignment_id' => 'integer',
        'type_id' => 'integer',
        'language_id' => 'integer',
        'session_id' => 'integer',
        'position_order' => 'integer',
        'file_index' => 'integer',
        'file_name' => 'string',
        'file_path' => 'string',
        'file_full_path' => 'string',
        'is_protected' => 'boolean',
        'file_price' => 'decimal:2',
        'file_password' => 'string',
        'status' => 'string',
    ];
}
