<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Crypt;

class GuessPapers extends Model
{
    use HasFactory;

    protected $table = 'guess_papers';
    protected $appends = ['highlights'];

    protected $fillable = [
        'subject_id',
        'type_ids',
        'language_ids',
        'session_ids',
        'coupon_ids',
        'position_order',
        'guess_paper_type',
        'guess_paper_code',
        'guess_paper_subject_name',
        'guess_paper_url',
        'guess_paper_title',
        'breadcrumb_headline',
        'maximum_retail_price',
        'selling_price',
        'discount',
        'additional_discount',
        'discount_offer_expiry',
        'guess_paper_expiry',
        'guess_paper_quantity',
        'guess_paper_image',
        'short_description',
        'download_info',
        'description',
        'question_paper_image',
        'why_choose_headline',
        'included_headline',
        'included_icons',
        'included_titles',
        'included_descriptions',
        'cover_page_info',
        'terms_conditions_text',
        'meta_title',
        'meta_keyword',
        'meta_description',
        'status'
    ];

    protected $casts = [
        'id' => 'integer',
        'subject_id' => 'integer',
        'type_ids' => 'json',
        'language_ids' => 'json',
        'session_ids' => 'json',
        'coupon_ids' => 'json',
        'position_order' => 'integer',
        'guess_paper_type' => 'string',
        'guess_paper_code' => 'string',
        'guess_paper_subject_name' => 'string',
        'guess_paper_url' => 'string',
        'guess_paper_title' => 'string',
        'breadcrumb_headline' => 'string',
        'maximum_retail_price' => 'decimal:2',
        'selling_price' => 'decimal:2',
        'discount' => 'integer',
        'additional_discount' => 'integer',
        'discount_offer_expiry' => 'datetime',
        'guess_paper_expiry' => 'datetime',
        'guess_paper_quantity' => 'integer',
        'guess_paper_image' => 'string',
        'short_description' => 'string',
        'download_info' => 'string',
        'description' => 'string',
        'question_paper_image' => 'string',
        'why_choose_headline' => 'string',
        'included_headline' => 'string',
        'included_icons' => 'json',
        'included_titles' => 'json',
        'included_descriptions' => 'json',
        'cover_page_info' => 'string',
        'terms_conditions_text' => 'string',
        'meta_title' => 'string',
        'meta_keyword' => 'string',
        'meta_description' => 'string',
        'status' => 'string',
    ];

    public function subject()
    {
        return $this->belongsTo(Subjects::class, 'subject_id', 'id');
    }

    public function getHighlightsAttribute()
    {
        $static = [
            "Easy to Understand & Exam Focused",
            "Perfect for Scoring High Marks",
            "100% Secure Payment & Instant Access After Payment",
            "Time-Saving and 100% Refund Solution"
        ];

        $highlights = GuessPaperWhyChoose::where('guess_paper_id', $this->id)
            ->pluck('guess_paper_content')
            ->filter()
            ->values();

        return $highlights->isEmpty() ? $static : $highlights;
    }

    public function getTypesAttribute()
    {
        return Types::whereIn('id', $this->type_ids ?? [])
            ->get()
            ->map(function ($type) {
                $type->encrypted_id = Crypt::encrypt($type->id);
                return $type;
            });
    }

    public function getLanguagesAttribute()
    {
        return Medium::whereIn('id', $this->language_ids ?? [])
            ->get()
            ->map(function ($language) {
                $language->encrypted_id = Crypt::encrypt($language->id);
                return $language;
            });
    }

    public function getSessionsAttribute()
    {
        return EducationalSessions::whereIn('id', $this->session_ids ?? [])
            ->get()
            ->map(function ($session) {
                $session->encrypted_id = Crypt::encrypt($session->id);
                return $session;
            });
    }

    public function getCouponsAttribute()
    {
        return Coupons::whereIn('id', $this->coupon_ids ?? [])
            ->get()
            ->map(function ($coupon) {
                $coupon->encrypted_id = Crypt::encrypt($coupon->id);
                return $coupon;
            });
    }
}
