<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Projects extends Model
{
    use HasFactory;

    protected $table = 'projects';
    protected $appends = ['highlights'];

    protected $fillable = [
        'subject_id',
        'type_ids',
        'language_ids',
        'session_ids',
        'coupon_ids',
        'position_order',
        'topics',
        'reference_number',
        'project_code',
        'project_subject_name',
        'project_url',
        'project_title',
        'breadcrumb_headline',
        'maximum_retail_price',
        'selling_price',
        'discount',
        'additional_discount',
        'discount_offer_expiry',
        'project_expiry',
        'project_quantity',
        'project_image',
        'demo_file',
        'project_file',
        'file_password',
        'short_description',
        'download_info',
        'description',
        'question_paper_image',
        'why_choose_headline',
        'cover_page_info',
        'meta_title',
        'meta_keyword',
        'meta_description',
        'status'
    ];

    protected $casts = [
        'id' => 'integer',
        'subject_id' => 'integer',
        'type_ids' => 'json',
        'language_ids' => 'json',
        'session_ids' => 'json',
        'coupon_ids' => 'json',
        'position_order' => 'integer',
        'topics' => 'json',
        'reference_number' => 'integer',
        'project_code' => 'string',
        'project_subject_name' => 'string',
        'project_url' => 'string',
        'project_title' => 'string',
        'breadcrumb_headline' => 'string',
        'maximum_retail_price' => 'decimal:2',
        'selling_price' => 'decimal:2',
        'discount' => 'integer',
        'additional_discount' => 'integer',
        'discount_offer_expiry' => 'datetime',
        'project_expiry' => 'datetime',
        'project_quantity' => 'integer',
        'project_image' => 'string',
        'demo_file' => 'string',
        'project_file' => 'string',
        'file_password' => 'string',
        'short_description' => 'string',
        'download_info' => 'string',
        'description' => 'string',
        'question_paper_image' => 'string',
        'why_choose_headline' => 'string',
        'cover_page_info' => 'string',
        'meta_title' => 'string',
        'meta_keyword' => 'string',
        'meta_description' => 'string',
        'status' => 'string',
    ];

    public function subject()
    {
        return $this->belongsTo(Subjects::class, 'subject_id', 'id');
    }

    public function getHighlightsAttribute()
    {
        $static = [
            "Easy to Understand & Exam Focused",
            "Perfect for Scoring High Marks",
            "100% Secure Payment & Instant Access After Payment",
            "Time-Saving and 100% Refund Solution"
        ];

        $highlights = ProjectWhyChoose::where('project_id', $this->id)
            ->pluck('project_content')
            ->filter()
            ->values();

        return $highlights->isEmpty() ? $static : $highlights;
    }

    public function getTypesAttribute()
    {
        return Types::whereIn('id', $this->type_ids ?? [])->get();
    }

    public function getLanguagesAttribute()
    {
        return Medium::whereIn('id', $this->language_ids ?? [])->get();
    }

    public function getSessionsAttribute()
    {
        return EducationalSessions::whereIn('id', $this->session_ids ?? [])->get();
    }

    public function getCouponsAttribute()
    {
        return Coupons::whereIn('id', $this->coupon_ids ?? [])->get();
    }
}
