<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Subjects extends Model
{
    use HasFactory;

    protected $table = 'subjects';

    protected $fillable = [
        'course_ids',
        'position_order',
        'subject_name',
        'subject_url',
        'subject_code',
        'course_year',
        'semesters',
        'status'
    ];

    protected $casts = [
        'id' => 'integer',
        'course_ids' => 'json',
        'position_order' => 'integer',
        'subject_name' => 'string',
        'subject_url' => 'string',
        'subject_code' => 'string',
        'course_year' => 'string',
        'semesters' => 'json',
        'status' => 'string',
    ];

    public function getCoursesAttribute()
    {
        return Courses::whereIn('id', $this->course_ids ?? [])->where('status', 'active')->get();
    }
}
