<?php

namespace App\Models;

use App\Models\Admin\Assignments;
use App\Models\Admin\Courses;
use App\Models\Admin\GuessPapers;
use App\Models\Admin\Projects;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CartItems extends Model
{
    use HasFactory;

    protected $table = 'cart_items';

    protected $fillable = [
        'item_id',
        'customer_id',
        'type_id',
        'language_id',
        'session_id',
        'course_id',
        'subject_id',
        'assignment_id',
        'project_id',
        'guess_paper_id',
        'quantity',
    ];

    public function assignment()
    {
        return $this->belongsTo(Assignments::class, 'assignment_id')->withDefault();
        // make sure 'assignment_id' is the correct foreign key
    }

    public function project()
    {
        return $this->belongsTo(Projects::class, 'project_id')->withDefault();
        // make sure 'project_id' is the correct foreign key
    }

    public function guessPaper()
    {
        return $this->belongsTo(GuessPapers::class, 'guess_paper_id')->withDefault();
        // make sure 'guess_paper_id' is the correct foreign key
    }

    public function course()
    {
        return $this->belongsTo(Courses::class, 'course_id');
        // make sure 'course_id' is the correct foreign key
    }
}
