<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Crypt;
use Laravel\Sanctum\HasApiTokens;

class CustomerCards extends Model
{
    use HasApiTokens;

    protected $table = 'customer_cards';

    protected $fillable = ['customer_id', 'card_holder_name', 'card_type', 'last4', 'expiry_month', 'expiry_year', 'is_default'];

    protected $appends = ['encrypted_id'];
    protected $hidden = ['id'];

    public function getEncryptedIdAttribute()
    {
        return Crypt::encrypt($this->id);
    }
}
