<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Laravel\Sanctum\HasApiTokens;

class OrderInvoices extends Model
{
    use HasApiTokens;

    protected $table = 'order_invoices';

    protected $fillable = ['order_id', 'invoice_id', 'transaction_id'];

    public function order()
    {
        return $this->belongsTo(Orders::class);
    }

    public function invoice()
    {
        return $this->belongsTo(Invoices::class);
    }

    public function transaction()
    {
        return $this->belongsTo(Transactions::class)->withDefault();
    }
}
