<?php

namespace App\Models;

use App\Models\Admin\Assignments;
use App\Models\Admin\Courses;
use App\Models\Admin\Projects;
use App\Models\Admin\Subjects;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderItems extends Model
{
    use HasFactory;

    protected $table = 'order_items';

    protected $fillable = [
        'order_id',
        'course_id',
        'subject_code',
        'assignment_id',
        'project_id',
        'price',
        'quantity',
        'total',
    ];

    public function order()
    {
        return $this->belongsTo(Orders::class, 'order_id');
    }

    public function course()
    {
        return $this->belongsTo(Courses::class, 'course_id');
    }

    public function subject()
    {
        return $this->belongsTo(Subjects::class, 'subject_id')->withDefault();
    }

    public function assignment()
    {
        return $this->belongsTo(Assignments::class, 'assignment_id')->withDefault();
    }

    public function project()
    {
        return $this->belongsTo(Projects::class, 'project_id')->withDefault();
    }
}
