<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Orders extends Model
{
    use HasFactory;

    protected $table = 'orders';

    protected $fillable = [
        'order_source',
        'order_number',
        'customer_id',
        'billing_details',
        'shipping_details',
        'payment_method',
        'subtotal',
        'total',
        'order_status',
        'status',
    ];

    protected $casts = [
        'billing_details'  => 'array',
        'shipping_details' => 'array',
    ];

    public function items()
    {
        return $this->hasMany(OrderItems::class, 'order_id');
    }

    public function transactions()
    {
        return $this->hasMany(Transactions::class, 'order_id');
    }

    public function invoices()
    {
        return $this->belongsToMany(Invoices::class, 'order_invoices', 'order_id', 'invoice_id');
    }
}
