<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Laravel\Sanctum\HasApiTokens;

class Transactions extends Model
{
    use HasApiTokens;

    protected $table = 'transactions';

    protected $fillable = ['customer_id', 'order_id', 'payment_method', 'payment_gateway', 'amount', 'gateway_transaction_id', 'gateway_response', 'currency', 'transaction_status', 'payment_details'];

    protected $casts = [
        'gateway_response' => 'array',
        'payment_details' => 'array',
        'amount' => 'decimal:2',
    ];

    public function customer()
    {
        return $this->belongsTo(Customers::class, 'customer_id');
    }

    public function order()
    {
        return $this->belongsTo(Orders::class, 'order_id');
    }
}
