<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('customer_id')->index();
            $table->unsignedBigInteger('order_id');
            $table->string('payment_method', 20);
            $table->string('payment_gateway')->nullable();
            $table->decimal('amount', 10, 2);
            $table->string('gateway_transaction_id')->unique()->nullable();
            $table->json('gateway_response')->nullable();
            $table->string('currency', 10)->nullable();

            $table->enum('transaction_status', ['initiated', 'success', 'failed', 'pending'])->default('initiated');
            $table->foreign('order_id')->references('id')->on('orders')->cascadeOnDelete();
            $table->json('payment_details')->nullable();

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
