<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('assignment_files', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('assignment_id')->index();
            $table->unsignedInteger('type_id')->index();
            $table->unsignedInteger('language_id')->index();
            $table->unsignedInteger('session_id')->index();
            $table->unsignedInteger('position_order');
            $table->unsignedInteger('file_index');
            $table->string('file_name');
            $table->string('file_path');
            $table->text('file_full_path')->nullable();
            $table->boolean('is_protected')->default(false);
            $table->decimal('file_price', 10, 2);
            $table->string('file_password')->nullable();
            $table->string('status')->default('active');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('assignment_files');
    }
};
