<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('guess_papers', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('subject_id')->index();
            $table->json('type_ids')->nullable();
            $table->json('language_ids')->nullable();
            $table->json('session_ids')->nullable();
            $table->json('coupon_ids')->nullable();
            $table->unsignedInteger('position_order');
            $table->string('guess_paper_code');
            $table->string('guess_paper_subject_name')->nullable();
            $table->string('guess_paper_url');
            $table->string('guess_paper_title')->nullable();
            $table->string('breadcrumb_headline')->nullable();
            $table->decimal('maximum_retail_price', 10, 2);
            $table->decimal('selling_price', 10, 2);
            $table->integer('discount')->nullable();
            $table->integer('additional_discount')->nullable();
            $table->timestamp('discount_offer_expiry')->nullable();
            $table->timestamp('guess_paper_expiry')->nullable();
            $table->integer('guess_paper_quantity')->nullable();
            $table->string('guess_paper_image')->nullable();
            $table->text('short_description')->nullable();
            $table->text('download_info')->nullable();
            $table->longText('description')->nullable();
            $table->string('question_paper_image')->nullable();
            $table->string('why_choose_headline')->nullable();
            $table->string('meta_title')->nullable();
            $table->text('meta_keyword')->nullable();
            $table->longText('meta_description')->nullable();
            $table->string('status')->default('active');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('guess_papers');
    }
};
