<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('guess_paper_why_chooses', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('guess_paper_id')->index();
            $table->unsignedInteger('position_order');
            $table->text('guess_paper_content')->nullable();
            $table->string('status')->default('active');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('guess_paper_why_chooses');
    }
};
