<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('files', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->index();
            $table->foreignId('module_id')->constrained('modules')->cascadeOnDelete();
            $table->string('original_name');
            $table->string('encrypted_name');
            $table->string('stored_path')->nullable(); // null if quarantined
            $table->string('scan_engine')->nullable();   // 'clamav'
            $table->string('scan_result')->nullable();   // e.g., 'OK' or 'Eicar-Test-Signature FOUND'
            $table->timestamp('scanned_at')->nullable();
            $table->unsignedBigInteger('size_bytes');
            $table->string('mime_type')->nullable();
            $table->string('passcode')->nullable();
            $table->unsignedBigInteger('total_downloads')->default(0);
            $table->string('file_status')->nullable();
            $table->enum('status', ['pending', 'clean', 'infected', 'quarantined'])->default('pending');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('files');
    }
};
