<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('plans', function (Blueprint $table) {
            $table->id();
            $table->integer('position_order');
            $table->string('plan_name', 255);
            $table->string('plan_category', 255)->nullable();
            $table->decimal('plan_price', 10, 2)->nullable();
            $table->string('plan_price_base', 255)->nullable();
            $table->integer('plan_storage_limit')->nullable();
            $table->text('short_description')->nullable();
            $table->longText('description')->nullable();
            $table->string('plan_image', 255)->nullable();
            $table->string('status')->default('active');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('plans');
    }
};
