<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('modules', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->index();
            $table->unsignedBigInteger('customer_id')->index();
            $table->string('send_option')->nullable();
            $table->string('email_to')->nullable();
            $table->string('your_email')->nullable();
            $table->boolean('terms')->default(false);
            $table->string('passcode')->nullable();
            $table->string('sharable_link')->nullable();
            $table->string('creation')->nullable();
            $table->string('validity')->nullable();
            $table->text('message')->nullable();
            $table->unsignedBigInteger('total_clicks')->default(0);
            $table->string('status')->default('active');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('modules');
    }
};
