@extends('admin.layouts.main-layout')
@section('title', 'Change Password')

@section('content')

    <div class="content-wrapper">
        <div class="container-xxl flex-grow-1 container-p-y">

            <div class="authentication-wrapper authentication-basic container-p-y">
                <div class="authentication-inner">

                    @if (session('error'))
                        <div class="alert alert-danger alert-dismissible" role="alert">
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    @if (session('success'))
                        <div class="alert alert-success alert-dismissible" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    <div class="card">
                        <div class="card-body">

                            <form id="password_form" action="{{ route('change.password') }}" method="POST"
                                onsubmit="return validatePasswordForm();">
                                @csrf

                                <div class="mb-3 form-password-toggle">
                                    <label class="form-label" for="old_pwd">Old Password</label>
                                    <div class="input-group input-group-merge">
                                        <input type="password" id="old_pwd" name="old_pwd" class="form-control"
                                            placeholder="Enter Old Password">
                                        <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                                    </div>
                                    <div id="old_pwd_error" class="text-danger"></div>
                                    @error('old_pwd')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3 form-password-toggle">
                                    <label class="form-label" for="new_pwd">New Password</label>
                                    <div class="input-group input-group-merge">
                                        <input type="password" id="new_pwd" name="new_pwd" class="form-control"
                                            placeholder="Enter New Password">
                                        <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                                    </div>
                                    <div id="new_pwd_error" class="text-danger"></div>
                                    @error('new_pwd')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3 form-password-toggle">
                                    <label class="form-label" for="new_pwd_confirmation">Confirm New Password</label>
                                    <div class="input-group input-group-merge">
                                        <input type="password" id="new_pwd_confirmation" name="new_pwd_confirmation"
                                            class="form-control" placeholder="Confirm New Password">
                                        <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                                    </div>
                                    <div id="confirm_pwd_error" class="text-danger"></div>
                                    @error('new_pwd_confirmation')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <button
                                        class="btn btn-primary d-grid w-100 d-flex justify-content-center align-items-center gap-2"
                                        id="updatePasswordBtn" type="submit">
                                        <span id="btnText">Update Password</span>
                                        <span id="btnLoader" class="spinner-border spinner-border-sm d-none" role="status"
                                            aria-hidden="true"></span>
                                    </button>

                                </div>
                            </form>

                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>


    <script>
        function validatePasswordForm() {
            let errors = 0;

            let oldPwd = $("#old_pwd").val().trim();
            let newPwd = $("#new_pwd").val().trim();
            let confirmPwd = $("#new_pwd_confirmation").val().trim();

            // Old password validation
            if (oldPwd === "") {
                $("#old_pwd_error").text("Old password is required.");
                errors++;
            } else {
                $("#old_pwd_error").text("");
            }

            // New password validation
            if (newPwd === "") {
                $("#new_pwd_error").text("New password is required.");
                errors++;
            } else {
                $("#new_pwd_error").text("");
            }

            // Confirm password validation
            if (confirmPwd === "") {
                $("#confirm_pwd_error").text("Confirm password is required.");
                errors++;
            } else if (confirmPwd !== newPwd) {
                $("#confirm_pwd_error").text("Passwords do not match.");
                errors++;
            } else {
                $("#confirm_pwd_error").text("");
            }

            if (errors > 0) {
                return false;
            } else {
                document.getElementById("btnText").textContent = "Please Wait...";
                document.getElementById("btnLoader").classList.remove("d-none");
                document.getElementById("updatePasswordBtn").disabled = true;
            }
        }
    </script>

@endsection
