@extends('admin.layouts.main-layout')
@php
    $title = 'View Customer Details';
@endphp
@section('title', $title)

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <h5 class="card-header">{{ $title }}<span class="float-end"><a href="{{ route('get.all.customers') }}"
                        class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                            style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-6">
                                    <label class="form-label">Name</label>
                                    <p>{{ $customer->first_name . ' ' . $customer->last_name }}</p>
                                </div>
                                <div class="col-6">
                                    <label class="form-label">Mobile Number</label>
                                    <p>{{ $customer->mobile }}</p>
                                </div>
                                <div class="col-6">
                                    <label class="form-label">E-Mail</label>
                                    <p>{{ $customer->email }}</p>
                                </div>
                                <div class="col-6">
                                    <label class="form-label">Status</label>
                                    <p>{{ $customer->status == 'active' ? 'Activated' : 'Blocked' }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <h5 class="card-header">Active Plan Details</h5>
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-6">
                                    <label for="plan_name" class="form-label">Plan</label>
                                    @if (isset($customer_plan->plan->plan_name) && !empty($customer_plan->plan->plan_name))
                                        <p>{{ $customer_plan->plan->plan_name }}</p>
                                    @else
                                        <p>Free</p>
                                    @endif
                                </div>
                                <div class="col-6">
                                    <label class="form-label">Price</label>
                                    @if (isset($customer_plan->plan->plan_price) &&
                                            $customer_plan->plan->plan_price != 0 &&
                                            isset($customer_plan->plan->plan_price_base) &&
                                            $customer_plan->plan->plan_price_base != '')
                                        <p>
                                            @if ($customer_transaction && $customer_transaction->currency)
                                                {{ $customer_transaction->currency }}
                                            @endif
                                            {{ $customer_plan->plan->plan_price . '/' . ucwords($customer_plan->plan->plan_price_base) }}
                                        </p>
                                    @else
                                        <p>INR 0</p>
                                    @endif
                                </div>
                                <div class="col-6">
                                    <label class="form-label">Expirying On</label>
                                    @if (isset($customer_plan->expiry_date) && !empty($customer_plan->expiry_date))
                                        <p>{{ date('F d, Y', strtotime($customer_plan->expiry_date)) }}</p>
                                    @else
                                        <p>Life-Time</p>
                                    @endif
                                </div>
                                <div class="col-6">
                                    <label class="form-label">Storage Limit</label>
                                    @if (isset($customer_plan->plan->plan_storage_limit) && $customer_plan->plan->plan_storage_limit != 0)
                                        <p>{{ $customer_plan->plan->plan_storage_limit . ' GB' }}</p>
                                    @else
                                        <p>1 GB</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            @if ($customer_transaction)
                <h5 class="card-header">Payment Details</h5>
                <div class="row">
                    <div class="col-12">
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <label class="form-label">Transaction Status</label>
                                        @if (isset($customer_transaction->transaction_status) && !empty($customer_transaction->transaction_status))
                                            <p>{{ $customer_transaction->transaction_status == 'success' ? 'Successful' : 'Failed' }}
                                            </p>
                                        @else
                                            <p>Pending</p>
                                        @endif
                                    </div>
                                    @if (isset($customer_transaction->payment_gateway) && !empty($customer_transaction->payment_gateway))
                                        <div class="col-6">
                                            <label for="plan_name" class="form-label">Payment Gateway</label>
                                            <p>{{ $customer_transaction->payment_gateway }}</p>
                                        </div>
                                    @endif
                                    <div class="col-6">
                                        <label class="form-label">Payment Order ID</label>
                                        @if (isset($customer_transaction->gateway_order_id) && !empty($customer_transaction->gateway_order_id))
                                            <p>{{ $customer_transaction->gateway_order_id }}</p>
                                        @endif
                                    </div>
                                    <div class="col-6">
                                        <label class="form-label">Payment ID</label>
                                        @if (isset($customer_transaction->gateway_payment_id) && !empty($customer_transaction->gateway_payment_id))
                                            <p>{{ $customer_transaction->gateway_payment_id }}
                                            </p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            @if ($customer_plan && $customer_plan->invoice)
                <h5 class="card-header">Payment Invoice Details</h5>
                <div class="row">
                    <div class="col-12">
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <label class="form-label">Invoice Status</label>
                                        @if (isset($customer_plan->invoice->status) && !empty($customer_plan->invoice->status))
                                            <p>{{ $customer_plan->invoice->status == 'success' ? 'Generated' : 'Failed' }}
                                            </p>
                                        @else
                                            <p>Pending</p>
                                        @endif
                                    </div>
                                    @if (isset($customer_plan->invoice->invoice_number) && !empty($customer_plan->invoice->invoice_number))
                                        <div class="col-6">
                                            <label for="plan_name" class="form-label">Invoice Number</label>
                                            <p>{{ $customer_plan->invoice->invoice_number }}</p>
                                        </div>
                                    @endif
                                    <div class="col-6">
                                        <label class="form-label">Invoice</label>
                                        @if (isset($customer_plan->invoice->encrypted_id) && !empty($customer_plan->invoice->encrypted_id))
                                            <p>
                                                <a href="{{ route('invoice.show', $customer_plan->invoice->encrypted_id) }}"
                                                    target="_blank" class="btn btn-primary mt-2">
                                                    View Invoice
                                                </a>
                                            </p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
@endsection
