@extends('admin.admin-layouts.main-layout')

<?php if(!empty($treatment)) {

    $title = "Edit Cost Treatment & Cost Sub-Treatment Management";

} else {

    $title = "Add Cost Treatment";

}



?>

@section('title', $title)



@section('content')

<!-- Content wrapper -->

<div class="content-wrapper">

    <!-- Content -->



    <div class="container-xxl flex-grow-1 container-p-y">

        <form action="{{ !empty($treatment) ? route('edit.cost.treatment', $treatment->encrypted_id) : route('add.cost.treatment') }}" method="POST" enctype="multipart/form-data">

            @csrf

            <!-- Hoverable Table rows -->

            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('manage_cost_treatments') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>

            <div class="row">

                <div class="col-md-9 mx-auto">

                    @if (session('error'))

                    <div class="alert alert-danger alert-dismissible" role="alert">

                        {{ session('error') }}

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>

                    </div>

                    @elseif (session('success'))

                    <div class="alert alert-success alert-dismissible" role="alert">

                        {{ session('success') }}

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>

                    </div>

                    @endif

                    <div class="card mb-4">

                        <div class="card-body">

                            <div class="row mb-3">

                                <label for="position_order" class="col-sm-3 col-form-label">Treatment Position</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="position_order"  oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ !empty($treatment) ? $treatment->position_order : '' }}" placeholder="Enter Position" />

                                    @error('position_order')

                                        <div class="text-danger">{{ $message }}</div>

                                    @enderror

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="treatment_headline" class="col-sm-3 col-form-label">Treatment Headline</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="treatment_headline" name="treatment_headline" value="{{ !empty($treatment) ? $treatment->treatment_headline : '' }}" placeholder="Enter Headline" />

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="description" class="col-sm-3 col-form-label">Description</label>

                                <div class="col-sm-9">

                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" >{{ !empty($treatment) ? htmlspecialchars_decode($treatment->description) : '' }}</textarea>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="demo-inline-spacing">

                        <input type="submit" value="{{ !empty($treatment) ? "Update Cost-Treatment" : "Add Cost-Treatment" }}" class="btn btn-primary" />

                        <a href="{{ route('manage_cost_treatments') }}" class="btn btn-outline-secondary">Back</a>

                    </div>

                </div>

            </div>

            <!--/ Hoverable Table rows -->

        </form>

        @if(!empty($treatment))

        <hr>

        <!-- Hoverable Table rows -->

        <div class="card mt-4">

            <h5 class="card-header">Cost Sub-Treatment Management


                <a href="{{ route('add.treatment.subtreatment', $treatment->encrypted_id) }}" class="btn rounded-pill btn-icon btn-outline-primary float-end" style="font-size: 1.7em;">+</span></a>

            </h5>

            <div class="table-responsive text-nowrap px-4 pb-4">

                <table id="table" class="table table-hover">

                    <thead>

                        <tr>

                            <th>S. No.</th>

                            <th>Sub-Treatment Title</th>

                            <th>Sub-Treatment Headline</th>

                            <th>Sub-Treatment Nature</th>

                            <th>Sub-Treatment Position</th>

                            <th>Status</th>

                            <th>Actions</th>

                        </tr>

                    </thead>

                    <tbody class="table-border-bottom-0">

                        <?php $sno = 1; ?>

                        @foreach($subtreatmentsData as $subtreatments)



                        <tr>

                            <td><?= $sno; ?></td>

                            <td><strong>{{ $subtreatments->treatment_title }}</strong></td>

                            <td>{{ $subtreatments->treatment_headline }}</td>

                            <td>{{ $subtreatments->nature }}</td>

                            <td>{{ $subtreatments->position_order }}</td>

                            <td>

                                <div class="form-check form-switch mb-2">

                                    <input class="form-check-input status_button" onclick="change_status('<?= $model; ?>', <?= $sno; ?>, '<?= $subtreatments->encrypted_id; ?>');" type="checkbox" id="status<?= $sno; ?>" <?= $subtreatments->status == 'active' ? 'checked' : ''; ?> />

                                </div>

                            </td>

                            <td>

                                <div class="dropdown">

                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">

                                        <i class="bx bx-dots-vertical-rounded"></i>

                                    </button>

                                    <div class="dropdown-menu">

                                        <a class="dropdown-item" href="{{ route('edit.treatment.subtreatment', ["treatment" => $treatment->encrypted_id, "subtreatment" => $subtreatments->encrypted_id]) }}" ><i class="bx bx-edit-alt me-1"></i> Edit</a>
                                        <button class="dropdown-item" onclick="delete_item('<?= $model; ?>', '<?= $subtreatments->encrypted_id; ?>');" >
                                            <i class="bx bx-trash me-1"></i> Delete
                                        </button>

                                    </div>

                                </div>

                            </td>

                        </tr>

                        <?php $sno++; ?>

                        @endforeach

                    </tbody>

                </table>

            </div>

        </div>

        <!--/ Hoverable Table rows -->

        @endif

    </div>

</div>



{{-- <script>



    function getUrl(id) {

        let treatment_title = $.trim($("#"+id).val());

        let treatment_link = treatment_title.replace(/\s+/g, '-').toLowerCase();

        $("#treatment_link").val(treatment_link);

    }



</script> --}}



@endsection

