@extends('admin.admin-layouts.main-layout')
<?php if(!empty($cost)) {
    $title = "Edit Country-wise Cost";
} else {
    $title = "Add Country-wise Cost";
}

?>
@section('title', $title)

@section('content')
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="{{ !empty($cost) ? route('edit.subtreatment.cost', ["treatment" => $enc_treatment_id, "subtreatment" => $enc_subtreatment_id, "cost" => $cost->encrypted_id]) : route('add.subtreatment.cost', ["treatment" => $enc_treatment_id, "subtreatment" => $enc_subtreatment_id]) }}" method="POST" enctype="multipart/form-data">
            @csrf
            <!-- Hoverable Table rows -->
            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('edit.treatment.subtreatment', ["treatment" => $enc_treatment_id, "subtreatment" => $enc_subtreatment_id]) }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-md-9 mx-auto">
                    @if (session('error'))
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row mb-3">
                                <label for="position_order" class="col-sm-3 col-form-label">Cost Position</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="position_order"  oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ !empty($cost) ? $cost->position_order : '' }}" placeholder="Enter Position" />
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="country_name" class="col-sm-3 col-form-label">Country Name</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="country_name" name="country_name" value="{{ !empty($cost) ? $cost->country_name : '' }}" placeholder="Enter Name" />
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="country_cost" class="col-sm-3 col-form-label">Country Cost</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="country_cost" name="country_cost" value="{{ !empty($cost) ? $cost->cost : '' }}" placeholder="Enter Country Cost" />
                                </div>
                            </div>
                            
                        </div>
                    </div>
                    <div class="demo-inline-spacing">
                        <input type="submit" value="{{ !empty($cost) ? 'Update Cost' : 'Add Cost' }}" class="btn btn-primary" />
                        <a href="{{ route('edit.treatment.subtreatment', ["treatment" => $enc_treatment_id, "subtreatment" => $enc_subtreatment_id]) }}" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
    </div>
</div>
@endsection
