@extends('layout')
@section('title', $meta['meta_title'].' | Medotilglobal Healthcare')
@section('meta_keywords', $meta['meta_keyword'])
@section('meta_description', $meta['meta_description'])
@section('head')
<link rel="stylesheet" type="text/css" href="https://jeremyfagis.github.io/dropify/dist/css/dropify.min.css">
@endsection
@section('content')
<!--<section class="breadcrum-area bg-sky">-->
<!--    <div class="container">-->
<!--        <nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='%236c757d'/%3E%3C/svg%3E&#34;);"-->
<!--            aria-label="breadcrumb">-->
<!--            <h1 class="text-center">{{ $category }}</h1>-->
<!--            <ol class="breadcrumb">-->
<!--                <li class="breadcrumb-item"><a href="{{ "/" }}"><i class="fa-solid fa-house"></i> Home</a></li>-->
<!--                {{-- <li class="breadcrumb-item" aria-current="page">Doctors</li> --}}-->
<!--                <li class="breadcrumb-item active" aria-current="page">{{ $category }}</li>-->
<!--            </ol>-->
<!--        </nav>-->
<!--    </div>-->
<!--</section>-->
<section class="doctor-search">
    <div class="container">
        <div class="wrapper">
            <div class="location-input-wrapper">
                <select id="doctor_city" class="form-select" aria-label="select">
                    {{-- <option value="" class="form-check-label" selected></option> --}}
                    @foreach($locationData as $location)
                    <option value="{{ $location->city_link }}" class="form-check-label">
                        {{ $location->city_name }}
                    </option>
                    @endforeach
                </select>
                <i class="fa-solid fa-location-dot" aria-hidden="true"></i>
            </div>
            <div class="search-input-wrapper">
                <input type="search" id="doctor_search" name="doctor_search" aria-label="search" id="search" class="form-control">
                <i class="fa-solid fa-magnifying-glass" aria-hidden="true"></i>
                <input type="hidden" id="doctor-search-id">
                <div id="doctor-suggestions" class="suggestions" style="display: none;"></div>
            </div>
        </div>
    </div>
</section>
<!-- Trained Doctors Section -->
<section class="hospital-network doctors-page section-padding pb-0">
    <div class="container">
        <div class="filter-bar">
    <button class="filter-button active">
        <svg xmlns="http://www.w3.org/2000/svg" fill="#fff" viewBox="0 0 24 24" class="icon">
            <path
                d="M12 3c2.755 0 5.455.232 8.083.678.533.09.917.556.917 1.096v1.044a2.25 2.25 0 01-.659 1.591l-5.432 5.432a2.25 2.25 0 00-.659 1.591v2.927a2.25 2.25 0 01-1.244 2.013L9.75 21v-6.568a2.25 2.25 0 00-.659-1.591L3.659 7.409A2.25 2.25 0 013 5.818V4.774c0-.54.384-1.006.917-1.096A48.32 48.32 0 0112 3z">
            </path>
        </svg>
        Filters <span class="badge">0</span>
    </button>
    <div class="dropdown">
        <select name="sort_data" class="dropdown-toggle filter-button" id="sort_data">
            <option value="low-to-high" selected>Low to High</option>
            <option value="high-to-low">High to Low</option>
        </select>
    </div>
    <div class="filter-item-wrapper">
        <input type="checkbox" name="filter_checkbox[]" id="female_checkbox" value="female">
        <label for="female_checkbox" class="filter-tag">
            Female Doctors
            <span class="close-btn">&times;</span>
        </label>
    </div>
    <div class="filter-item-wrapper">
        <input type="checkbox" name="filter_checkbox[]" id="experience20_checkbox" value="experience20">
        <label for="experience20_checkbox" class="filter-tag">
            20+ Years of Experience
            <span class="close-btn">&times;</span>
        </label>
    </div>
    <div class="filter-item-wrapper">
        <input type="checkbox" name="filter_checkbox[]" id="experience10_checkbox" value="experience10">
        <label for="experience10_checkbox" class="filter-tag">
            10+ Years of Experience
            <span class="close-btn">&times;</span>
        </label>
    </div>
</div>
        <div class="hospital-work-inner page">
            <div class="row align-items-start">
                <div class="bg-secondary">{{ $category }}</div>
                <div class="col-lg-9 col-md-7">
                    <div class="doctor-list"></div>
                    <a href="javascript:void(0);" class="text-decoration-underline fw-bold" id="load-more-btn"
                        data-page="1">Load More Profiles <i class="fa-solid fa-arrow-right"></i></a>
                </div>
                <div class="col-lg-3 col-md-5 sticky">
                    <aside>
                        <h4>Need Assistance ?</h4>
                        <form action="">
                            <div class="input-wrapper">
                                <input type="text" name="name" class="form-control" placeholder="Name">
                            </div>
                            <div class="input-wrapper">
                                <select name="" class="form-select" id="">
                                    <option value="" selected disable>Select Your Country...</option>
                                    <option value="1">Maleshiya</option>
                                    <option value="2">Ghana</option>
                                </select>
                            </div>
                            <div class="input-wrapper">
                                <input type="hidden" id="quoteCountryCodeAbr" name="quote_country_code" value="91">
                                <input type="text" id="quote_phone" name="quote_phone" class="form-control"
                                    placeholder="Phone Number" maxlength="15">
                            </div>
                            <div class="input-wrapper">
                                <input type="email" name="" class="form-control" placeholder="Email" id="">
                            </div>
                            <div class="input-wrapper">
                                <textarea name="" id="" class="form-control" placeholder="Your Query"></textarea>
                            </div>
                            <div class="input-wrapper">
                                <input name="file1" type="file" class="dropify" />
                            </div>
                            <div class="input-wrapper">
                                <div id="g_recaptcha_2" class="g-recaptcha"
                                    data-sitekey="{{ env('GOOGLE_RECAPTCHA_SITE_KEY') }}"></div>
                            </div>
                            <div class="input-wrapper">
                                <button type="submit" class="button-style33">Submit Now <span><i
                                            class="fa-solid fa-arrow-right"></i></span></button>
                            </div>
                        </form>
                    </aside>
                </div>
            </div>
        </div>
    </div>
</section>
{{-- <section class="trained-doctors section-padding page bg-sky">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="section-heading text-center">
                    <h2 class="wow fadeInUp">Find Highly Trained Doctors</h2>
                </div>
            </div>
        </div>
        <div class="wrapper">
            @if($doctorsData->isEmpty())
            <h4>***Data Not Found for {{ $category }}!!!</h4>
@else
<div class="tab-content mt-5" id="pills-tabContent">
    <div class="tab-pane fade show active" id="pills-dentist" role="tabpanel" aria-labelledby="pills-dentist-tab"
        tabindex="0">
        <div class="row justify-content-center">
            @foreach($doctorsData as $doctors)
            <div class="col-xl-6">
                <div class="inner">
                    <a
                        href="{{ route('doctor.show', ['category' => $doctors->category_link, 'doctor' => $doctors->doctor_link]) }}"><img
                            src="{{ asset('storage/'.$doctors->doctor_image) }}" alt="Doctor_Image"></a>
                    <div class="content-area">
                        <a
                            href="{{ route('doctor.show', ['category' => $doctors->category_link, 'doctor' => $doctors->doctor_link]) }}">
                            <h4>{{ $doctors->doctor_name }}</h4>
                        </a>
                        <h5>{{ $doctors->designation }}</h5>
                        <p>{{ substr(strip_tags(htmlspecialchars_decode($doctors->description)), 0, 80).'...' }}</p>
                        <a href="{{ route('doctor.show', ['category' => $doctors->category_link, 'doctor' => $doctors->doctor_link]) }}"
                            class="button-style4 text-white">Read full details</a>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>
@endif
</div>
</div>
</section> --}}
{{-- @dd($hospitalsData) --}}
@if($hospitalsData->isEmpty() === false)
<!-- Hospital Network Slider -->
<section class="hospital-network-slider-section section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="section-heading">
                    <h2 class="text-white">Network Hospitals</h2>
                </div>
            </div>
        </div>
    </div>
    <div class="hospital-network-slider position-relative">
        @foreach($hospitalsData as $hospitals)
        @php
        $hospitalImage = json_decode($hospitals->hospital_images, true);
        @endphp
        <div class="item">
            <div class="image-area">
                <img src="{{ (!empty($hospitalImage) ? asset('storage/'.$hospitalImage[0]) : '') }}"
                    alt="{{ $hospitals->hospital_name }}">
            </div>
            <div class="content-area">
                <a href="{{ route('hospital', $hospitals->hospital_link) }}">{{ $hospitals->hospital_name }}</a>
                <div class="date">Established in {{ $hospitals->established_in }} </div>
                <div class="footer-para">
                    <a
                        href="{{ route('hospital', $hospitals->hospital_link) }}">{{ substr(strip_tags(htmlspecialchars_decode($hospitals->description)), 0, 55).'...' }}</a>
                </div>
            </div>
        </div>
        @endforeach
    </div>
    <div class="bottom-link"><a href="{{ route('all.doc.cat.hospitals', $category_link) }}">Read More</a></div>
</section>
@endif
@endsection
@section('tail')
<script type="text/javascript" src="https://jeremyfagis.github.io/dropify/dist/js/dropify.min.js"></script>
<script>
$('.dropify').dropify();
// $(document).ready(function () {
//     // Track active filters
//     let activeFilters = [];
//     let sortOrder = 'low-to-high'; // default sort order
//     // Update badge with active filters count
//     function updateBadge() {
//         $(".badge").text(activeFilters.length);
//     }
//     // Toggle filter tag active state and apply filtering logic
//     $(".filter-tag").on("click", function () {
//         const filter = $(this).data("filter");
//         // Toggle active class
//         $(this).toggleClass("active");
//         // Add or remove filter from activeFilters array
//         if ($(this).hasClass("active")) {
//             activeFilters.push(filter);
//         } else {
//             activeFilters = activeFilters.filter(f => f !== filter);
//         }
//         // Update the filter count
//         updateBadge();
//         // Filter doctors based on active filters
//         $(".doctor").each(function () {
//             const categories = $(this).data("category").split(" ");
//             const isVisible = activeFilters.every((filter) => categories.includes(filter));
//             $(this).toggleClass('hidden', !isVisible);
//         });
//     });
//     // Remove individual filter tags when cross icon is clicked
//     $(".filter-tag .icon-close").on("click", function (e) {
//         e.stopPropagation();
//         const filterTag = $(this).closest(".filter-tag");
//         const filter = filterTag.data("filter");
//         filterTag.removeClass("active");
//         activeFilters = activeFilters.filter(f => f !== filter);
//         // Update the filter count and filter display
//         updateBadge();
//         $(".doctor").each(function () {
//             const categories = $(this).data("category").split(" ");
//             const isVisible = activeFilters.every((filter) => categories.includes(filter));
//             $(this).toggleClass('hidden', !isVisible);
//         });
//     });
//     // Sorting logic
//     $(".sort-option").on("click", function () {
//         sortOrder = $(this).data("sort");
//         // console.log(sortOrder);
//         sortDoctors();
//     });
//     function sortDoctors() {
//         const doctors = $(".doctor").get();
//         doctors.sort((a, b) => {
//             const expA = parseInt($(a).data("category").match(/\d+/)[0]);
//             const expB = parseInt($(b).data("category").match(/\d+/)[0]);
//             return sortOrder === 'low-to-high' ? expA - expB : expB - expA;
//         });
//         $(".doctor-list").html(doctors);
//     }
// });
</script>
<script>
$(document).ready(function() {
    var all_filters = [];
    var load_spin = "{{ asset('assets/images/loading-spinner-final.svg') }}";
    var page = 1;
    function loadMoreBtn() {
        $("#load-more-btn").after('<span class="data_load ms-2"><img src="' + load_spin +
            '" height="25px" width="25px" /></span>');
        page = parseInt($("#load-more-btn").attr('data-page'), 10);
        applyFilters(all_filters, page);
    }
    $("#load-more-btn").on('click', loadMoreBtn);
    // $("#load-more-btn").trigger("click");
    function updateSortData() {
        $(".doctor-list").html('<div class="text-center"><img src="' + load_spin +
            '" height="50px" width="50px" /></div>');
        var sort_filter = $("select[name='sort_data']").val();
        var filter = {
            sortedFilters: sort_filter, // Add sorted data to the filter
        };
        // Ensure the filter is updated instead of duplicating
        all_filters = all_filters.filter(f => !f.sortedFilters); // Remove any existing sortedFilters
        all_filters.push(filter);
        applyFilters(all_filters, page);
    }
    $("#sort_data").on("change", updateSortData);
    $("#sort_data").trigger("change");
    $("input[name='filter_checkbox[]']").on("change", function() {
        $(".doctor-list").html('<div class="text-center"><img src="' + load_spin +
            '" height="50px" width="50px" /></div>');
        // Get all checked filters
        var selected_filters = $("input[name='filter_checkbox[]']:checked")
            .map(function() {
                return $(this).val(); // Get the value of each selected checkbox
            })
            .get(); // Convert to plain JavaScript array
        var filter = {
            selectedFilters: selected_filters,
        };
        all_filters = all_filters.filter(f => !f
        .selectedFilters); // Remove any existing selectedFilters
        all_filters.push(filter);
        // console.log(all_filters);
        // return false;
        applyFilters(all_filters, page);
    });
     // Function to update the filter count badge
    function updateFilterCount() {
        // Get all checkboxes
        const checkboxes = document.querySelectorAll('input[name="filter_checkbox[]"]');
        const badge = document.querySelector('.filter-button .badge');
        // Count checked checkboxes
        const appliedFilters = Array.from(checkboxes).filter(checkbox => checkbox.checked).length;
        // Update the badge text
        badge.textContent = appliedFilters;
    }
    // Attach event listeners to all checkboxes
    const filterCheckboxes = document.querySelectorAll('input[name="filter_checkbox[]"]');
    filterCheckboxes.forEach(checkbox => {
        checkbox.addEventListener('change', updateFilterCount);
    });
    // Initial count on page load
    updateFilterCount();
    // Function to apply filters (example logic)
    function applyFilters(filters, page) {
        // console.log("Applying filters to data:", filters);
        const token = "{{ csrf_token() }}";
        const category_link = "{{ $category_link }}";
        $.ajax({
            url: "{{ route('get.filtered.doctors') }}",
            data: {
                '_token': token,
                'category_link': category_link,
                'all_filters': filters,
                'page': page,
                'current_page': 'doctors',
            },
            method: "POST",
            dataType: "json",
            success: function(all_data) {
                if (all_data.html) {
                    setTimeout(() => {
                        if (page == 1) {
                            $(".doctor-list").html(all_data.html);
                        } else {
                            $(".doctor-list").append(all_data.html);
                            $(".data_load").remove();
                        }
                    }, 1000);
                }
                if (!all_data.has_more) {
                    $("#load-more-btn").text("No More Profiles").addClass("disabled").off("click");
                    $(".data_load").remove();
                }
                $("#load-more-btn").attr('data-page', page + 1);
                // $(".load-more-div").html('<a href="javascript:void(0);" class="text-decoration-underline fw-bold" id="load-more-btn" data-page="'+(page + 1)+'">Load More Profiles <i class="fa-solid fa-arrow-right"></i></a>');
                // $("#load-more-btn").prop('disabled', false);
                // console.log(all_data);
                // return false;
            },
            error: function() {
                alert("Failed to load more profiles. Please try again.");
            },
        });
    }
});

$('#doctor_search').on('keyup', function() {
    let doctor_city = $('#doctor_city').val();
    let doctor_query = $(this).val();
    if (doctor_query.length > 0) {
        $.ajax({
            url: '{{ route("view.doctor.suggestions") }}',
            type: 'GET',
            data: {
                query: doctor_query,
                city: doctor_city
            },
            success: function(data) {
                let doctor_suggestions = $('#doctor-suggestions');
                doctor_suggestions.empty().show();
                if (data.length > 0) {
                    data.forEach(function(item) {
                        if (item.doctor_name) {
                            doctor_suggestions.append(`
                                <div class="suggestion-item" data-id="${item.id}" data-name="${item.doctor_name}">
                                    <a href="/doctors/${item.category.link}/${item.doctor_link}">${item.doctor_name}</a>
                                </div>
                            `);
                        }
                    });
                } else {
                    doctor_suggestions.append(
                        '<div class="suggestion-item">No Results Found!</div>');
                }
            }
        });
    } else {
        $('#doctor-suggestions').hide();
    }
});

</script>
@endsection