@extends('admin.admin-layouts.main-layout')

<?php if(!empty($hospital)) {

    $title = "Edit Hospital";

} else {

    $title = "Add Hospital";

}



?>

@section('title', $title)



@section('content')

<!-- Content wrapper -->

<div class="content-wrapper">

    <!-- Content -->



    <div class="container-xxl flex-grow-1 container-p-y">

        <form action="{{ !empty($hospital) ? route('edit.hospital', $hospital->encrypted_id) : route('add.hospital') }}" method="POST" enctype="multipart/form-data">

            @csrf

            <!-- Hoverable Table rows -->

            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('manage_hospitals') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>

            <div class="row">

                <div class="col-md-9 mx-auto">

                    @if (session('error'))

                    <div class="alert alert-danger alert-dismissible" role="alert">

                        {{ session('error') }}

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>

                    </div>

                    @endif

                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-6 mb-2">
                                    <label for="position_order" class="form-label">Hospital Position</label>
                                    <input type="text" class="form-control" id="position_order"  oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ !empty($hospital) ? $hospital->position_order : '' }}" placeholder="Enter Position" />
                                    @error('position_order')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                {{-- <div class="col-sm-6">
                                    <label for="category" class="form-label">Doctor Category</label>
                                    @php $create = true; @endphp
                                    <select name="category" id="category" class="form-control">
                                        @foreach($categoriesData as $categories)
                                            @if(!empty($doctor))
                                            <option value="{{ $categories->encrypted_id }}" {{ ($doctor->id == $categories->id) ? "selected" : "" }}>{{ $categories->category_name }}</option>
                                            @else
                                                @if($create == true)
                                                <option value="" selected>--- Select Category ---</option>
                                                @php $create = false; @endphp
                                                @endif
                                            <option value="{{ $categories->encrypted_id }}">{{ $categories->category_name }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div> --}}
                                <div class="col-sm-6">
                                    <label for="hospital_name" class="form-label">Hospital Name</label>
                                    <input type="text" class="form-control" id="hospital_name" name="hospital_name" value="{{ !empty($hospital) ? $hospital->hospital_name : '' }}" placeholder="Enter Name" onblur="getUrl(this.id)" />
                                    @error('hospital_name')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-sm-6 mb-2">
                                    <label for="hospital_link" class="form-label">Hospital URL</label>
                                    <input type="text" class="form-control" id="hospital_link" name="hospital_link" value="{{ !empty($hospital) ? $hospital->hospital_link : '' }}" placeholder="Enter URL" />

                                    @error('hospital_link')

                                        <div class="text-danger">{{ $message }}</div>

                                    @enderror
                                </div>
                                <div class="col-sm-6">
                                    <label for="established_in" class="form-label">Established In</label>
                                    <input type="text" class="form-control" id="established_in" name="established_in" value="{{ !empty($hospital) ? $hospital->established_in : '' }}" placeholder="Enter Year" />
                                    @error('established_in')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-sm-6 mb-2">
                                    <label for="hospital_beds" class="form-label">No. of Beds</label>
                                    <input type="text" class="form-control" id="hospital_beds" name="hospital_beds" value="{{ !empty($hospital) ? $hospital->hospital_beds : '' }}" placeholder="Enter No. of Beds" />
                                    @error('hospital_beds')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-sm-6">
                                    <label for="hospital_doctors" class="form-label">No. of Doctors</label>
                                    <input type="text" class="form-control" id="hospital_doctors" name="hospital_doctors" value="{{ !empty($hospital) ? $hospital->hospital_doctors : '' }}" placeholder="Enter No. of Doctors" />
                                    @error('hospital_doctors')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-sm-6 mb-2">
                                    <label for="accredited_by" class="form-label">Accredited By</label>
                                    <input type="text" class="form-control" id="accredited_by" name="accredited_by" value="{{ !empty($hospital) ? $hospital->accredited_by : '' }}" placeholder="Enter Accredited By" />
                                    @error('accredited_by')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-sm-6">
                                    <label for="near_airports" class="form-label">Near By Airport(s)</label>
                                    <input type="text" class="form-control" id="near_airports" name="near_airports" value="{{ !empty($hospital) ? $hospital->near_airports : '' }}" placeholder="Enter Airport(s)" />
                                    @error('near_airports')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-sm-6 mb-2">
                                    <label for="hospital_phone" class="form-label">Hospital Phone</label>
                                    <input type="text" class="form-control" id="hospital_phone" name="hospital_phone" value="{{ !empty($hospital) ? $hospital->hospital_phone : '' }}" placeholder="Enter Phone" />
                                </div>
                                <div class="col-sm-6">
                                    <label for="hospital_email" class="form-label">Hospital E-Mail</label>
                                    <input type="text" class="form-control" id="hospital_email" name="hospital_email" value="{{ !empty($hospital) ? $hospital->hospital_email : '' }}" placeholder="Enter E-Mail" />
                                </div>
                                <div class="col-sm-12">
                                    <label for="city" class="form-label">Hospital City</label>
                                    @php $create = true; @endphp
                                    <select name="city" id="city" class="form-control">
                                        @foreach($citiesData as $cities)
                                            @if(!empty($hospital))
                                            <option value="{{ $cities->encrypted_id }}" {{ ($hospital->city_id == $cities->id) ? "selected" : "" }}>{{ $cities->city_name }}</option>
                                            @else
                                                @if($create == true)
                                                <option value="" selected>--- Select City ---</option>
                                                @php $create = false; @endphp
                                                @endif
                                            <option value="{{ $cities->encrypted_id }}">{{ $cities->city_name }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                    @error('city')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                {{-- <div class="col-sm-6">
                                    <label for="map_link" class="form-label">Google Map Link</label>
                                    <input type="text" class="form-control" id="map_link" name="map_link" value="{{ !empty($hospital) ? $hospital->map_link : '' }}" placeholder="Enter Map Link" />
                                </div> --}}
                                <div class="col-sm-12">
                                    <label for="hospital_location" class="col-sm-3 col-form-label">Hospital Location</label>
                                    <textarea name="hospital_location" id="hospital_location" cols="30" rows="5" class="form-control" placeholder="Enter Location" >{{ !empty($hospital) ? htmlspecialchars_decode($hospital->hospital_location) : '' }}</textarea>
                                </div>
                                <div class="col-sm-12">
                                    <label for="description" class="col-sm-3 col-form-label">Description</label>
                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" >{{ !empty($hospital) ? htmlspecialchars_decode($hospital->description) : '' }}</textarea>
                                </div>
                                <div class="col-sm-6 mb-3">
                                    <label for="meta_title" class="col-sm-3 col-form-label">Meta Title</label>
                                    <input type="text" class="form-control" id="meta_title" name="meta_title" value="{{ !empty($hospital) ? $hospital->meta_title : '' }}" placeholder="Enter Meta Title" />
                                </div>
                                <div class="col-sm-6">
                                    <label for="meta_keyword" class="col-sm-3 col-form-label">Meta Keyword</label>
                                    <input type="text" class="form-control" id="meta_keyword" name="meta_keyword" value="{{ !empty($hospital) ? $hospital->meta_keyword : '' }}" placeholder="Enter Meta Keyword" />
                                </div>
                                <div class="col-sm-12">
                                    <label for="meta_description" class="col-sm-3 col-form-label">Meta Description</label>
                                    <textarea name="meta_description" id="meta_description" cols="30" rows="5" class="form-control" placeholder="Enter Meta Description" >{{ !empty($hospital) ? htmlspecialchars_decode($hospital->meta_description) : '' }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-2">

                        {{-- <div class="col-sm-6">

                            <div class="card mb-3">

                                <div class="card-body row">

                                    <label for="treatment_icon" class="col-sm-3 col-form-label">Treatment Icon</label>

                                    <div class="col-sm-9">

                                        @if(!empty($hospital))

                                        <div class="my-3">

                                            <img src="{{ asset('storage/' . $hospital->treatment_icon) }}" alt="Treatment_Icon" class="rounded" height="50px" width="50px">

                                        </div>

                                        @endif

                                        <input class="form-control" type="file" id="treatment_icon" name="treatment_icon" accept=".jpg, .jpeg, .png, .webp" />

                                    </div>

                                </div>

                            </div>

                        </div> --}}

                        <div class="col-sm-12">
                            <div class="card mb-3">
                                <div class="card-body row">
                                    <label for="hospital_images" class="col-sm-3 col-form-label">Hospital Images</label>
                                    <div class="col-sm-9">
                                        @if(!empty($hospital))
                                        <div class="my-3">
                                            @php
                                                $hospital_images = json_decode($hospital->hospital_images);
                                            @endphp
                                            @if (!empty($hospital->hospital_images))
                                                @foreach($hospital_images as $image)
                                                <img src="{{ asset('storage/' . $image) }}" alt="Hospital_Images" class="rounded" height="50px" width="50px">
                                                @endforeach
                                            @endif
                                        </div>
                                        @endif
                                        <input class="form-control" type="file" id="hospital_images" name="hospital_images[]" accept=".jpg, .jpeg, .png, .webp" multiple />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card mb-3">
                                <div class="card-body">
                                    <div class="row mb-3">
                                        <div class="col-sm-6">
                                            <label for="first_section_image" class="form-label">Left Section First Image</label>
                                            @if (!empty($hospital->first_section_image))
                                                <div class="my-3">
                                                    <img src="{{ asset('storage/' . $hospital->first_section_image) }}" alt="First_Section_Image" class="rounded" height="50px" width="50px">
                                                </div>
                                            @endif
                                            <input class="form-control" type="file" id="first_section_image" name="first_section_image" accept=".jpg, .jpeg, .png, .webp" />
                                        </div>
                                        <div class="col-sm-6">
                                            @php
                                            if(!empty($hospital)) {
                                                $first_data = json_decode($hospital->first_section_data);
                                            }
                                            @endphp
                                            <label for="first_section_data" class="form-label">Left Section First Data</label>
                                            <input type="text" class="form-control mb-2" id="first_section_data" name="first_section_data[]" value="{{ !empty($first_data) ? $first_data[0] : '' }}" placeholder="Enter Headline" />
                                            <input type="text" class="form-control" id="first_section_data_two" name="first_section_data[]" value="{{ !empty($first_data) ? $first_data[1] : '' }}" placeholder="Enter Data" />
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <label for="second_section_image" class="form-label">Left Section Second Image</label>
                                            @if (!empty($hospital->second_section_image))
                                                <div class="my-3">
                                                    <img src="{{ asset('storage/' . $hospital->second_section_image) }}" alt="Second_Section_Image" class="rounded" height="50px" width="50px">
                                                </div>
                                            @endif
                                            <input class="form-control" type="file" id="second_section_image" name="second_section_image" accept=".jpg, .jpeg, .png, .webp" />
                                        </div>
                                        <div class="col-sm-6">
                                            @php
                                            if(!empty($hospital)) {
                                                $second_data = json_decode($hospital->second_section_data);
                                            }
                                            @endphp
                                            <label for="second_section_data" class="form-label">Left Section Second Data</label>
                                            <input type="text" class="form-control mb-2" id="second_section_data" name="second_section_data[]" value="{{ !empty($second_data) ? $second_data[0] : '' }}" placeholder="Enter Headline" />
                                            <input type="text" class="form-control" id="second_section_data" name="second_section_data[]" value="{{ !empty($second_data) ? $second_data[1] : '' }}" placeholder="Enter Data" />
                                            @error('hospital_name')
                                                <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card mb-3">
                                <div class="card-body">
                                    <div class="row">
                                        @php
                                        if(!empty($hospital)) {
                                            $counter_field = json_decode($hospital->counter_field, true);
                                            $json_counter_headline = json_decode($hospital->counter_headline, true);
                                            $counter_headline = [];
                                            foreach($json_counter_headline as $headline) {
                                                $counter_headline[] = htmlspecialchars_decode($headline);
                                            }
                                        }
                                        @endphp
                                        <div class="col-sm-6 mb-2">
                                            <label for="field_one" class="form-label">Counter Field One</label>
                                            <input type="text" class="form-control" id="field_one" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" name="counter_field[]" value="{{ !empty($counter_field) ? $counter_field[0] : '' }}" placeholder="Enter Count One" />
                                        </div>
                                        <div class="col-sm-6">
                                            <label for="headline_one" class="form-label">Counter One Headline</label>
                                            <input type="text" class="form-control" id="headline_one" name="counter_headline[]" value="{{ !empty($counter_headline) ? $counter_headline[0] : '' }}" placeholder="Enter One Headline" />
                                        </div>
                                        <div class="col-sm-6 mb-2">
                                            <label for="field_two" class="form-label">Counter Field Two</label>
                                            <input type="text" class="form-control" id="field_two" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" name="counter_field[]" value="{{ !empty($counter_field) ? $counter_field[1] : '' }}" placeholder="Enter Count Two" />
                                        </div>
                                        <div class="col-sm-6">
                                            <label for="headline_two" class="form-label">Counter Two Headline</label>
                                            <input type="text" class="form-control" id="headline_two" name="counter_headline[]" value="{{ !empty($counter_headline) ? $counter_headline[1] : '' }}" placeholder="Enter Two Headline" />
                                        </div>
                                        <div class="col-sm-6 mb-2">
                                            <label for="field_three" class="form-label">Counter Field Three</label>
                                            <input type="text" class="form-control" id="field_three" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" name="counter_field[]" value="{{ !empty($counter_field) ? $counter_field[2] : '' }}" placeholder="Enter Count Three" />
                                        </div>
                                        <div class="col-sm-6">
                                            <label for="headline_three" class="form-label">Counter Three Headline</label>
                                            <input type="text" class="form-control" id="headline_three" name="counter_headline[]" value="{{ !empty($counter_headline) ? $counter_headline[2] : '' }}" placeholder="Enter Three Headline" />
                                        </div>
                                        <div class="col-sm-6 mb-2">
                                            <label for="field_four" class="form-label">Counter Field Four</label>
                                            <input type="text" class="form-control" id="field_four" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" name="counter_field[]" value="{{ !empty($counter_field) ? $counter_field[3] : '' }}" placeholder="Enter Count Four" />
                                        </div>
                                        <div class="col-sm-6">
                                            <label for="headline_four" class="form-label">Counter Four Headline</label>
                                            <input type="text" class="form-control" id="headline_four" name="counter_headline[]" value="{{ !empty($counter_headline) ? $counter_headline[3] : '' }}" placeholder="Enter Four Headline" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="demo-inline-spacing">

                        <input type="submit" value="{{ !empty($hospital) ? "Update Hospital" : "Add Hospital" }}" class="btn btn-primary" />

                        <a href="{{ route('manage_hospitals') }}" class="btn btn-outline-secondary">Back</a>

                    </div>

                </div>

            </div>

            <!--/ Hoverable Table rows -->

        </form>

    </div>

</div>



<script>



    function getUrl(id) {

        let hospital_name = $.trim($("#"+id).val());

        let hospital_link = hospital_name.replace(/\s+/g, '-').toLowerCase();

        $("#hospital_link").val(hospital_link);

    }



</script>



@endsection

