@extends('admin.admin-layouts.main-layout')
<?php if(!empty($hospital_tech)) {
    $title = "Edit Technological Advancement";
} else {
    $title = "Add Technological Advancement";
}

?>
@section('title', $title)

@section('content')
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="{{ !empty($hospital_tech) ? route('edit.technological', $hospital_tech->encrypted_id) : route('add.technological') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <!-- Hoverable Table rows -->
            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('manage_technologicals') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-md-9 mx-auto">
                    @if (session('error'))
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row mb-3">
                                <label for="position_order" class="col-sm-3 col-form-label">Techno Position</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="position_order" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ !empty($hospital_tech) ? $hospital_tech->position_order : '' }}" placeholder="Enter Position" />
                                    @error('position_order')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="techno_headline" class="col-sm-3 col-form-label">Hospitals</label>
                                <div class="col-sm-9">
                                    @php $create = true; @endphp
                                    <select name="hospital" id="hospital" class="form-control">
                                        @foreach($techno_hospitalsData as $techno_hospitals)
                                            @if(!empty($hospital_tech))
                                            <option value="{{ $techno_hospitals->encrypted_id }}" {{ ($hospital_tech->hospital_id == $techno_hospitals->id) ? "selected" : "" }}>{{ $techno_hospitals->hospital_name }}</option>
                                            @else
                                                @if($create == true)
                                                <option selected>--- Select Hospital ---</option>
                                                @php $create = false; @endphp
                                                @endif
                                            <option value="{{ $techno_hospitals->encrypted_id }}">{{ $techno_hospitals->hospital_name }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                    @error('hospital')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="techno_headline" class="col-sm-3 col-form-label">Techno Headline</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="techno_headline" name="techno_headline" value="{{ !empty($hospital_tech) ? $hospital_tech->techno_headline : '' }}" placeholder="Enter Headline" />
                                    @error('techno_headline')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="description" class="col-sm-3 col-form-label">Description</label>
                                <div class="col-sm-9">
                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" >{{ !empty($hospital_tech) ? htmlspecialchars_decode($hospital_tech->description) : '' }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card mb-3">
                                <div class="card-body row">
                                    <label for="techno_image" class="col-sm-3 col-form-label">Techno Image</label>
                                    <div class="col-sm-9">
                                        @if(!empty($hospital_tech))
                                        <div class="my-3">
                                            <img src="{{ asset('storage/' . $hospital_tech->techno_image) }}" alt="{{ $hospital_tech->techno_headline }}" class="rounded" height="50px" width="50px">
                                        </div>
                                        @endif
                                        <input class="form-control" type="file" id="techno_image" name="techno_image" accept=".jpg, .jpeg, .png, .gif, .webp" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="demo-inline-spacing">
                        <input type="submit" value="{{ !empty($hospital_tech) ? 'Update Hospital Techno' : 'Add Hospital Techno' }}" class="btn btn-primary" />
                        <a href="{{ route('manage_technologicals') }}" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
    </div>
</div>

@endsection
