@extends('admin.admin-layouts.main-layout')

<?php if(!empty($hospital_treatment)) {

    $title = "Edit Hospital Treatment";

} else {

    $title = "Add Hospital Treatment";

}



?>

@section('title', $title)



@section('content')

<!-- Content wrapper -->

<div class="content-wrapper">

    <!-- Content -->



    <div class="container-xxl flex-grow-1 container-p-y">

        <form action="{{ !empty($hospital_treatment) ? route('edit.hospital_treatment', $hospital_treatment->encrypted_id) : route('add.hospital_treatment') }}" method="POST" enctype="multipart/form-data">

            @csrf

            <!-- Hoverable Table rows -->

            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('manage_hospital_treatments') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>

            <div class="row">

                <div class="col-md-9 mx-auto">

                    @if (session('error'))

                    <div class="alert alert-danger alert-dismissible" role="alert">

                        {{ session('error') }}

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>

                    </div>

                    @endif

                    <div class="card mb-4">

                        <div class="card-body">

                            <div class="row mb-3">

                                <label for="position_order" class="col-sm-3 col-form-label">Treatment Position</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="position_order" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ !empty($hospital_treatment) ? $hospital_treatment->position_order : '' }}" placeholder="Enter Position" />
                                    @error('position_order')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="hospital" class="col-sm-3 col-form-label">Hospitals</label>

                                <div class="col-sm-9">

                                    @php $create = true; @endphp

                                    <select name="hospital" id="hospital" class="form-control">

                                        @foreach($treatment_hospitalsData as $treatment_hospitals)

                                            @if(!empty($hospital_treatment))

                                            <option value="{{ $treatment_hospitals->encrypted_id }}" {{ ($hospital_treatment->hospital_id == $treatment_hospitals->id) ? "selected" : "" }}>{{ $treatment_hospitals->hospital_name }}</option>

                                            @else

                                                @if($create == true)

                                                <option selected>--- Select Hospital ---</option>

                                                @php $create = false; @endphp

                                                @endif

                                            <option value="{{ $treatment_hospitals->encrypted_id }}">{{ $treatment_hospitals->hospital_name }}</option>

                                            @endif

                                        @endforeach

                                    </select>

                                    @error('hospital')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="treatment_headline" class="col-sm-3 col-form-label">Treatment Headline</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="treatment_headline" name="treatment_headline" value="{{ !empty($hospital_treatment) ? $hospital_treatment->treatment_headline : '' }}" placeholder="Enter Headline" />

                                    @error('treatment_headline')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="row">

                        <div class="col-sm-12">

                            <div class="card mb-3">

                                <div class="card-body row">

                                    <label for="treatment_image" class="col-sm-3 col-form-label">Treatment Image</label>

                                    <div class="col-sm-9">

                                        @if(!empty($hospital_treatment))

                                        <div class="my-3">

                                            <img src="{{ asset('storage/' . $hospital_treatment->treatment_image) }}" alt="{{ $hospital_treatment->treatment_headline }}" class="rounded" height="50px" width="50px">

                                        </div>

                                        @endif

                                        <input class="form-control" type="file" id="treatment_image" name="treatment_image" accept=".jpg, .jpeg, .png, .gif, .webp, .svg" />

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="demo-inline-spacing">

                        <input type="submit" value="{{ !empty($hospital_treatment) ? 'Update Hospital Treatment' : 'Add Hospital Treatment' }}" class="btn btn-primary" />

                        <a href="{{ route('manage_hospital_treatments') }}" class="btn btn-outline-secondary">Back</a>

                    </div>

                </div>

            </div>

            <!--/ Hoverable Table rows -->

        </form>

    </div>

</div>



@endsection