@extends('admin.admin-layouts.main-layout')

@section('title', 'Manage Hospital Treatments')



@section('content')

<!-- Content wrapper -->

<div class="content-wrapper">

    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">

        @if (session('success'))

            <div class="alert alert-success alert-dismissible" role="alert">

                {{ session('success') }}

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>

            </div>

        @endif

        <!-- Hoverable Table rows -->

        <div class="card">

            <h5 class="card-header">Manage Hospital Treatments<a href="{{ route('add.hospital_treatment') }}" class="btn rounded-pill btn-icon btn-outline-primary float-end" style="font-size: 1.7em;">+</span></a></h5>

            <div class="table-responsive text-nowrap px-4 pb-4">

                <table id="table" class="table table-hover">

                    <thead>

                        <tr>

                            <th>S. No.</th>

                            <th>Treatment Hospital</th>

                            <th>Treatment Headline</th>

                            <th>Treatment Position</th>

                            <th>Treatment Images</th>

                            <th>Status</th>

                            <th>Actions</th>

                        </tr>

                    </thead>

                    <tbody class="table-border-bottom-0">

                        <?php $sno = 1; ?>

                        @foreach($hospital_treatmentsData as $hospital_treatments)

                        <tr>

                            <td><?= $sno; ?>.</td>

                            <td>{{ $hospital_treatments->hospital->hospital_name }}</td>

                            <td><strong>{{ $hospital_treatments->treatment_headline }}</strong></td>

                            <td>{{ $hospital_treatments->position_order }}</td>

                            <td>

                                <ul class="list-unstyled users-list m-0 avatar-group d-flex align-items-center">

                                    <li data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="top" class="avatar avatar-md pull-up" title="{{ $hospital_treatments->treatment_headline }}" >

                                        <img src="{{ asset('storage/' . $hospital_treatments->treatment_image) }}" alt="{{ $hospital_treatments->treatment_headline }}" class="rounded-circle" />

                                    </li>

                                </ul>

                            </td>

                            <td>

                                <div class="form-check form-switch mb-2">

                                    <input class="form-check-input status_button" onclick="change_status('<?= $model; ?>', <?= $sno; ?>, '<?= $hospital_treatments->encrypted_id; ?>');" type="checkbox" id="status<?= $sno; ?>" <?= $hospital_treatments->status == 'active' ? 'checked' : ''; ?> />

                                </div>

                            </td>

                            <td>

                                <div class="dropdown">

                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">

                                        <i class="bx bx-dots-vertical-rounded"></i>

                                    </button>

                                    <div class="dropdown-menu">

                                        <a class="dropdown-item" href="{{ route('edit.hospital_treatment', $hospital_treatments->encrypted_id) }}" >

                                            <i class="bx bx-edit-alt me-1"></i> Edit

                                        </a>

                                        <button class="dropdown-item" onclick="delete_item('<?= $model; ?>', '<?= $hospital_treatments->encrypted_id; ?>');" >

                                            <i class="bx bx-trash me-1"></i> Delete

                                        </button>

                                    </div>

                                </div>

                            </td>

                        </tr>

                        <?php $sno++; ?>

                        @endforeach

                    </tbody>

                </table>

            </div>

        </div>

        <!--/ Hoverable Table rows -->

    </div>

</div>



@endsection