@extends('admin.admin-layouts.main-layout')
<?php if(!empty($med_content)) {
    $title = "Edit Med-India Section Content";
} else {
    $title = "Add Med-India Section Content";
}

?>
@section('title', $title)

@section('content')
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="{{ !empty($med_content) ? route('edit.medcontent', $med_content->encrypted_id) : route('add.medcontent') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <!-- Hoverable Table rows -->
            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('manage_med_contents') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-md-9 mx-auto">
                    @if (session('error'))
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row mb-3">
                                <label for="position_order" class="col-sm-3 col-form-label">Med-Content Position</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="position_order" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ !empty($med_content) ? $med_content->position_order : '' }}" placeholder="Enter Position" />
                                    @error('position_order')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="med_section" class="col-sm-3 col-form-label">Med-India Section</label>
                                <div class="col-sm-9">
                                    @php $create = true; @endphp
                                    <select name="med_section" id="med_section" class="form-control">
                                        @foreach($med_sections as $med_section)
                                            @if(!empty($med_content))
                                            <option value="{{ $med_section->encrypted_id }}" {{ ($med_content->section_id == $med_section->id) ? "selected" : "" }}>{{ $med_section->section_title }}</option>
                                            @else
                                                @if($create == true)
                                                <option value="" selected>--- Select Section ---</option>
                                                @php $create = false; @endphp
                                                @endif
                                            <option value="{{ $med_section->encrypted_id }}">{{ $med_section->section_title }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                    @error('med_section')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            {{-- <div class="row mb-3">
                                <label for="content_title" class="col-sm-3 col-form-label">Med-Content Title</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="content_title" name="content_title" value="{{ !empty($med_content) ? $med_content->content_title : '' }}" placeholder="Enter Title" />
                                </div>
                            </div> --}}
                            <div class="row mb-3">
                                <label for="content_headline" class="col-sm-3 col-form-label">Med-Content Headline</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="content_headline" name="content_headline" value="{{ !empty($med_content) ? $med_content->content_headline : '' }}" placeholder="Enter Headline" />
                                    @error('content_headline')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="description" class="col-sm-3 col-form-label">Description</label>
                                <div class="col-sm-9">
                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" >{{ !empty($med_content) ? htmlspecialchars_decode($med_content->description) : '' }}</textarea>
                                    @error('description')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card mb-3">
                                <div class="card-body row">
                                    <label for="content_image" class="col-sm-3 col-form-label">Med-Content Image</label>
                                    <div class="col-sm-9">
                                        @if(!empty($med_content))
                                        <div class="my-3">
                                            <img src="{{ asset('storage/' . $med_content->content_image) }}" alt="med_content_Image" class="rounded" height="50px" width="50px">
                                        </div>
                                        @endif
                                        <input class="form-control" type="file" id="content_image" name="content_image" accept=".jpg, .jpeg, .png, .gif, .webp" />
                                        @error('content_image')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="demo-inline-spacing">
                        <input type="submit" value="{{ !empty($med_content) ? 'Update Med-Content' : 'Add Med-Content' }}" class="btn btn-primary" />
                        <a href="{{ route('manage_med_contents') }}" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
    </div>
</div>

@endsection
