@extends('admin.admin-layouts.main-layout')

<?php if(!empty($partner)) {

    $title = "Edit Partner";

} else {

    $title = "Add Partner";

}



?>

@section('title', $title)



@section('content')

<!-- Content wrapper -->

<div class="content-wrapper">

    <!-- Content -->



    <div class="container-xxl flex-grow-1 container-p-y">

        <form action="{{ !empty($partner) ? route('edit.partner', $partner->encrypted_id) : route('add.partner') }}" method="POST" enctype="multipart/form-data">

            @csrf

            <!-- Hoverable Table rows -->

            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('manage_partners') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>

            <div class="row">

                <div class="col-md-9 mx-auto">

                    @if (session('error'))

                    <div class="alert alert-danger alert-dismissible" role="alert">

                        {{ session('error') }}

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>

                    </div>

                    @endif

                    <div class="card mb-4">

                        <div class="card-body">

                            <div class="row mb-3">

                                <label for="position_order" class="col-sm-3 col-form-label">Partner Position</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="position_order" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ !empty($partner) ? $partner->position_order : '' }}" placeholder="Enter Position" />

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="partner_name" class="col-sm-3 col-form-label">Partner Name</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="partner_name" name="partner_name" value="{{ !empty($partner) ? $partner->partner_name : '' }}" placeholder="Enter Name" />

                                </div>

                            </div>

                            {{-- <div class="row mb-3">

                                <label for="partner_link" class="col-sm-3 col-form-label">Partner URL</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="partner_link" name="partner_link" value="{{ !empty($partner) ? $partner->partner_link : '' }}" placeholder="Enter URL" />

                                </div>

                            </div> --}}

                            <div class="row mb-3">

                                <label for="country_name" class="col-sm-3 col-form-label">Partner Country Name</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="country_name" name="country_name" value="{{ !empty($partner) ? $partner->country_name : '' }}" placeholder="Enter Country Name" />

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="row">

                        <div class="col-sm-12">

                            <div class="card mb-3">

                                <div class="card-body row">

                                    <label for="partner_image" class="col-sm-3 col-form-label">Partner Image</label>

                                    <div class="col-sm-9">

                                        @if(!empty($partner))

                                        <div class="my-3">

                                            <img src="{{ asset('storage/' . $partner->partner_image) }}" alt="Partner_Image" class="rounded" height="50px" width="50px">

                                        </div>

                                        @endif

                                        <input class="form-control" type="file" id="partner_image" name="partner_image" />

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="demo-inline-spacing">

                        <input type="submit" value="{{ !empty($partner) ? 'Update Partner' : 'Add Partner' }}" class="btn btn-primary" />

                        <a href="{{ route('manage_partners') }}" class="btn btn-outline-secondary">Back</a>

                    </div>

                </div>

            </div>

            <!--/ Hoverable Table rows -->

        </form>

    </div>

</div>



@endsection

