@extends('admin.layouts.main-layout')

<?php if (!empty($free_download->encrypted_id)) {
    $title = 'Edit Free Download / Guess Paper';
} else {
    $title = 'Add Free Download / Guess Paper';
}
?>
@section('title', $title)

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form
                action="{{ !empty($free_download->encrypted_id) ? route('edit.free.download', $free_download->encrypted_id) : route('add.free.download') }}"
                method="POST" enctype="multipart/form-data">
                @csrf
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="{{ route('manage.free.downloads') }}"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-md-12">
                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <label for="file_type" class="col-form-label">File Type</label>
                                        <select name="file_type" id="file_type" class="form-select">
                                            <option value="">-- Select File --</option>
                                            @if (!empty($free_download->encrypted_id))
                                                <option value="free_download"
                                                    {{ $free_download->file_type == 'free_download' ? 'selected' : '' }}>
                                                    Free Download
                                                </option>
                                                <option value="cover_page"
                                                    {{ $free_download->file_type == 'cover_page' ? 'selected' : '' }}>
                                                    Cover Page
                                                </option>
                                            @else
                                                <option value="free_download">Free Download</option>
                                                <option value="cover_page">Cover Page</option>
                                            @endif
                                        </select>
                                        @error('file_type')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="file_name" class="col-form-label">File Name</label>
                                        <input type="text" class="form-control" id="file_name" name="file_name"
                                            value="{{ !empty($free_download->encrypted_id) ? $free_download->file_name : old('file_name') }}"
                                            placeholder="Enter Name" />
                                        @error('file_name')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6 mt-3">
                                        <input type="checkbox" class="form-check-input me-2 main-category"
                                            name="file_on_top_banner" value="on_top_banner" id="file_on_top_banner"
                                            {{ !empty($free_download->encrypted_id) ? ($free_download->file_on_top_banner == 'on_top_banner' ? 'checked' : '') : '' }}>
                                        <label for="file_on_top_banner" class="fw-semibold">
                                            On Top Banner
                                        </label>
                                    </div>
                                    {{-- <div class="col-6">
                                        <label for="button_name" class="col-form-label">Button</label>
                                        <div class="mb-3">
                                            <input type="text" class="form-control" id="button_name" name="button_name"
                                                value="{{ !empty($free_download->encrypted_id) ? $free_download->button_name : old('button_name') }}"
                                                placeholder="Enter Name" />
                                        </div>
                                        <div class="mb-3">
                                            <input type="text" class="form-control" id="button_link" name="button_link"
                                                value="{{ !empty($free_download->encrypted_id) ? $free_download->button_link : old('button_link') }}"
                                                placeholder="Enter Link" />
                                        </div>
                                    </div> --}}
                                    {{-- <div class="col-6">
                                        <label for="other_button_name" class="col-form-label">Other Button</label>
                                        <div class="mb-3">
                                            <input type="text" class="form-control" id="other_button_name"
                                                name="other_button_name"
                                                value="{{ !empty($free_download->encrypted_id) ? $free_download->other_button_name : old('other_button_name') }}"
                                                placeholder="Enter Name" />
                                        </div>
                                        <div class="mb-3">
                                            <input type="text" class="form-control" id="other_button_link"
                                                name="other_button_link"
                                                value="{{ !empty($free_download->encrypted_id) ? $free_download->other_button_link : old('other_button_link') }}"
                                                placeholder="Enter Link" />
                                        </div>
                                    </div> --}}
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="card mb-3">
                                    <div class="card-body row">
                                        <div class="col-12">
                                            <label for="file" class="col-form-label">File</label>
                                            @if (!empty($free_download->encrypted_id) && !empty($free_download->file))
                                                <div style="display: inline-block; position: relative; margin: 30px;"
                                                    class="my-3">
                                                    <strong>Current Free File:</strong>

                                                    <p class="mb-2">
                                                        {{ basename($free_download->file) }}
                                                    </p>

                                                    @if (file_exists(public_path($free_download->file)))
                                                        <a href="{{ asset($free_download->file) }}"
                                                            class="btn btn-sm btn-primary" download>
                                                            Download File
                                                        </a>
                                                    @endif
                                                    {{-- <button
                                                        style="position: absolute; top: -5px; right: -5px; width: 20px; height: 20px; background: red; color: white; border: none; border-radius: 50%; font-size: 14px; cursor: pointer;">×</button> --}}

                                                    {{-- <button
                                                        type="button"
                                                        onclick="removeDemoPdf()"
                                                        style="position:absolute; top:-6px; right:-6px; width:22px; height:22px; 
                                                            background:red; color:white; border:none; border-radius:50%; 
                                                            font-size:14px; cursor:pointer; line-height:18px;">
                                                        ×
                                                    </button>

                                                    {{-- tells backend to delete on submit
                                                    <input type="hidden" name="remove_demo_file" id="remove_demo_file" value="0"> --}}
                                                </div>
                                            @endif
                                            <input class="form-control" type="file" id="file" name="file"
                                                accept="application/pdf" />
                                            @error('file')
                                                <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{-- <div class="row">
                        <div class="col-sm-12">
                            <div class="card mb-3">
                                <div class="card-body row">
                                    <label for="free_download_icons" class="col-form-label">free_download Icons</label>
                                    <div class="col-sm-9">
                                        @if (!empty($free_download->encrypted_id))
                                        <div class="my-3">
                                            @if (!empty($free_download->free_download_icons))
                                            @php
                                                $free_download_icons = json_decode($free_download->free_download_icons);
                                            @endphp
                                                @foreach ($free_download_icons as $icon)
                                                <div style="display: inline-block; position: relative; margin: 5px;">
                                                    <img src="{{ asset($icon->file_path) }}" alt="free_download_Icons" class="rounded" height="60px" width="60px" style="object-fit: cover;">
                                                    <button style="position: absolute; top: -5px; right: -5px; width: 20px; height: 20px; background: red; color: white; border: none; border-radius: 50%; font-size: 14px; cursor: pointer;">×</button>
                                                </div>
                                                @endforeach
                                            @endif
                                        </div>
                                        @endif
                                        <input class="form-control" type="file" id="free_download_icons" name="free_download_icons[]" accept="image/*" multiple />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> --}}
                        <div class="demo-inline-spacing">
                            <input type="submit"
                                value="{{ !empty($free_download->encrypted_id) ? 'Update File Data' : 'Add File Data' }}"
                                class="btn btn-primary" />
                            <a href="{{ route('manage.free.downloads') }}" class="btn btn-outline-secondary">Back</a>
                        </div>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>

@endsection
