@extends('admin.layouts.main-layout')

@section('title', 'Manage Contact')



@section('content')

    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->

        <div class="container-xxl flex-grow-1 container-p-y">
            <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Company Settings /</span> Contact Details</h4>

            <div class="row">
                <div class="col-md-12">
                    <form method="POST" enctype="multipart/form-data"
                        action="{{ route('edit.contact', $contact->encrypted_id) }}">
                        @csrf
                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @elseif (session('success'))
                            <div class="alert alert-success alert-dismissible" role="alert">
                                {{ session('success') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="card mb-4">
                            <!-- Account -->
                            <div class="card-body">
                                <div class="row">
                                    <div class="mb-3 col-md-6">
                                        <label for="phone" class="form-label">Company Phone</label>
                                        <input type="text" class="form-control" id="phone" name="phone"
                                            oninput="this.value = this.value.replace(/[^0-9+()\-]/g, '').replace(/(\..*?)\..*/g, '$1');"
                                            maxlength="15" value="{{ $contact->phone }}" placeholder="Enter Phone" />
                                        @error('phone')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="mb-3 col-md-6">
                                        <label for="whatsapp_phone" class="form-label">WhatsApp Phone</label>
                                        <input type="text" class="form-control" id="whatsapp_phone" name="whatsapp_phone"
                                            oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*?)\..*/g, '$1');"
                                            maxlength="15" value="{{ $contact->whatsapp_phone }}"
                                            placeholder="Enter WhatsApp Phone" />
                                    </div>
                                    <div class="mb-3 col-md-6">
                                        <label for="alternate_phone" class="form-label">Company Alternate Phone</label>
                                        <input type="text" class="form-control" id="alternate_phone"
                                            name="alternate_phone"
                                            oninput="this.value = this.value.replace(/[^0-9+()\-]/g, '').replace(/(\..*?)\..*/g, '$1');"
                                            maxlength="15" value="{{ $contact->alternate_phone }}"
                                            placeholder="Enter Alternate Phone" />
                                    </div>
                                    <div class="mb-3 col-md-6">
                                        <label for="mail" class="form-label">Company E-Mail</label>
                                        <input type="email" class="form-control" id="mail" name="mail"
                                            value="{{ $contact->email }}" placeholder="Enter E-Mail" />
                                        @error('mail')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="mb-3 col-md-6">
                                        <label for="alternate_email" class="form-label">Company Alternate E-Mail</label>
                                        <input type="email" class="form-control" id="alternate_email"
                                            name="alternate_email" value="{{ $contact->alternate_email }}"
                                            placeholder="Enter Alternate E-Mail" />
                                    </div>
                                    {{-- <div class="mb-3 col-md-6" id="map_link_div">
                                    <label for="company_map_link" class="form-label">Company Map Link</label>
                                    <input type="text" class="form-control" id="company_map_link" name="company_map_link" value="{{ htmlspecialchars_decode($contact->company_map_link) }}" placeholder="Enter Company Map Link" />
                                    <div id="company_map_link_error" class="text-danger"></div>
                                </div> --}}
                                    <div class="mb-3 col-md-6">
                                        <label for="map_link_visibility" class="form-label">Google Map Link
                                            Visibility</label>
                                        <select name="map_link_visibility"
                                            onchange="change_map_link_visibility(this.value);" id="map_link_visibility"
                                            class="form-select form-select">
                                            <option value="yes"
                                                {{ $contact->map_link_visibility == 'yes' ? 'selected' : '' }}>YES
                                            </option>
                                            <option value="no"
                                                {{ $contact->map_link_visibility == 'no' ? 'selected' : '' }}>NO</option>
                                        </select>
                                    </div>
                                    <div class="mb-3 col-md-6" id="map_link_div">
                                        <label for="map_link" class="form-label">Google Map Link</label>
                                        <input type="text" class="form-control" id="map_link" name="map_link"
                                            value="{{ htmlspecialchars_decode($contact->map_link) }}"
                                            placeholder="Enter Map Link" />
                                        <div id="map_link_error" class="text-danger"></div>
                                    </div>
                                    <div class="mb-3 col-md-6">
                                        <label for="footer_location" class="form-label">Footer Location</label>
                                        <input type="text" class="form-control" id="footer_location"
                                            name="footer_location" value="{{ $contact->footer_location }}"
                                            placeholder="Enter Location" />
                                    </div>
                                    <div class="mb-3 col-md-6">
                                        <label for="availability" class="form-label">Company Availability</label>
                                        <textarea name="availability" id="availability" cols="30" rows="5" class="form-control"
                                            placeholder="Enter Availability">
                                        @php
                                            echo htmlspecialchars_decode($contact->availability);
                                        @endphp
                                    </textarea>
                                    </div>
                                    <div class="mb-3 col-md-6">
                                        <label for="location" class="form-label">Company Location</label>
                                        <textarea name="location" id="location" cols="30" rows="5" class="form-control"
                                            placeholder="Enter Location">
                                        @php
                                            echo htmlspecialchars_decode($contact->location);
                                        @endphp
                                    </textarea>
                                    </div>
                                    <div class="mb-3 col-md-6">
                                        <label for="alternate_location" class="form-label">Company Alternate
                                            Location</label>
                                        <textarea name="alternate_location" id="alternate_location" cols="30" rows="5" class="form-control"
                                            placeholder="Enter Alternate Location">
                                        @php
                                            echo htmlspecialchars_decode($contact->alternate_location);
                                        @endphp
                                    </textarea>
                                    </div>
                                </div>
                                <div class="mt-2">
                                    <input type="submit" value="Update Contact" class="btn btn-primary me-2" />
                                </div>

                            </div>
                            <!-- /Account -->
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        function change_map_link_visibility(value) {
            if (value == "yes") {
                $("#map_link_div").show();
            } else {
                $("#map_link_div").hide();
            }
            return false;
        }

        change_map_link_visibility('{{ $contact->map_link_visibility }}');
    </script>

@endsection
