@extends('admin.layouts.main-layout')
@section('title', 'Manage Coupons')

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            @if (session('success'))
                <div class="alert alert-success alert-dismissible" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @elseif(session('error'))
                <div class="alert alert-danger alert-dismissible" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            <!-- Hoverable Table rows -->
            <div class="card">
                <h5 class="card-header">Manage Coupons<a href="{{ route('add.coupon') }}"
                        class="btn rounded-pill btn-icon btn-outline-primary float-end"
                        style="font-size: 1.7em;">+</span></a></h5>
                <div class="table-responsive text-nowrap px-4 pb-4">
                    <table id="table" class="table table-hover">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th>Reference Type</th>
                                <th>Generated Coupon</th>
                                <th>Coupon Validity</th>
                                <th>Coupon Name</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                            <?php $sno = 1; ?>
                            @foreach ($couponsData as $coupon)
                                <tr>
                                    <td><?= $sno ?>.</td>
                                    <td>
                                        @if ($coupon->reference_type == 'assignment')
                                            Assignment
                                        @else
                                            Project
                                        @endif
                                    </td>
                                    <td><strong>{{ $coupon->coupon }}</strong></td>
                                    <td class="text-danger">
                                        {{ date('h:i:s - F d, Y', strtotime($coupon->coupon_validity)) }}</td>
                                    <td>{{ $coupon->coupon_name }}</td>
                                    <td>
                                        <div class="form-check form-switch mb-2">
                                            <input class="form-check-input status_button"
                                                onclick="change_status('<?= $model ?>', <?= $sno ?>, '<?= $coupon->encrypted_id ?>');"
                                                type="checkbox" id="status<?= $sno ?>"
                                                <?= $coupon->status == 'active' ? 'checked' : '' ?> />
                                        </div>
                                    </td>
                                    <td>
                                        <div class="dropdown">
                                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                                data-bs-toggle="dropdown">
                                                <i class="bx bx-dots-vertical-rounded"></i>
                                            </button>
                                            <div class="dropdown-menu">
                                                <a class="dropdown-item"
                                                    href="{{ route('edit.coupon', ['coupon' => $coupon->encrypted_id]) }}">
                                                    <i class="bx bx-edit-alt me-1"></i> Edit
                                                </a>
                                                <button class="dropdown-item"
                                                    onclick="delete_item('<?= $model ?>', '<?= $coupon->encrypted_id ?>');">
                                                    <i class="bx bx-trash me-1"></i> Delete
                                                </button>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php $sno++; ?>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </div>
    </div>
@endsection

@section('admin-custom-js')
    <script>
        $("#table").DataTable();
    </script>
@endsection
