@extends('admin.layouts.main-layout')

@section('title', 'Manage Pages')

@section('content')
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">
        @if (session('success'))
            <div class="alert alert-success alert-dismissible" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
        <!-- Hoverable Table rows -->
        <div class="card">
            <h5 class="card-header">Manage Pages
                @if(session()->get('role') == 'superadmin')
                <a href="{{ route('add.page') }}" class="btn rounded-pill btn-icon btn-outline-primary float-end" style="font-size: 1.7em;">+</span></a>
                @endif
                <a href="{{ route('get.pages.page') }}" class="btn btn-primary float-end me-2">Pages Sequence</a>
            </h5>
            <div class="table-responsive text-nowrap px-4 pb-4">
                <table id="table" class="table table-hover">
                    <thead>
                        <tr>
                            <th>S. No.</th>
                            <th>Page Name</th>
                            @if(session()->get('role') == 'superadmin')
                            <th>Page Position</th>
                            @endif
                            <th>Client Page URLs</th>
                            <th>Visibility</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        <?php $sno = 1; ?>
                        @foreach($pagesData as $pages)
                        <tr>
                            <td><?= $sno; ?>.</td>
                            <td>
                                <strong>{{ $pages->page_name }}</strong>
                            </td>
                            @if(session()->get('role') == 'superadmin')
                            <td>{{ $pages->position_order }}</td>
                            @endif
                            <?php if(empty($pages->client_page_urls) || $pages->client_page_urls == 'index' || $pages->client_page_urls == 'home') {
                                $client_url = '/';
                            }
                            else {
                                $client_url = '/'.$pages->client_page_urls;
                            }
                            ?>
                            <td>
                                <a href="{{ $client_url }}">
                                    <small><strong>{{ $pages->header_footer_name }}</strong></small>
                                </a>
                            </td>
                            @if($pages->id != 1 || session('role') == 'superadmin')
                            <td>
                                <select onchange="change_visibility('<?= $model; ?>', <?= $sno; ?>, '<?= $pages->encrypted_id; ?>');" id="visibility<?= $sno; ?>" class="form-select form-select-sm">
                                    <option value="header" <?= (($pages->visibility) == 'header' ? 'selected' : ''); ?>>HEADER</option>
                                    <option value="footer" <?= (($pages->visibility) == 'footer' ? 'selected' : ''); ?>>FOOTER</option>
                                    <option value="both" <?= (($pages->visibility) == 'both' ? 'selected' : ''); ?>>BOTH</option>
                                    <option value="none" <?= (($pages->visibility) == 'none' ? 'selected' : ''); ?>>NONE</option>
                                </select>
                                <div class="text-danger" id="visibility_error<?= $sno; ?>"></div>
                            </td>
                            <td>
                                <div class="form-check form-switch mb-2">
                                    <input class="form-check-input status_button" onclick="change_status('<?= $model; ?>', <?= $sno; ?>, '<?= $pages->encrypted_id; ?>');" type="checkbox" id="status<?= $sno; ?>" <?= $pages->status == 'active' ? 'checked' : ''; ?> />
                                </div>
                            </td>
                            @else
                            <td></td>
                            <td></td>
                            @endif
                            <td>
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="{{ route('edit.page', $pages->encrypted_id) }}" >
                                            <i class="bx bx-edit-alt me-1"></i> Edit
                                        </a>
                                        @if(session()->get('role') == 'superadmin')
                                        <button class="dropdown-item" onclick="delete_item('<?= $model; ?>', '<?= $pages->encrypted_id; ?>');" >
                                            <i class="bx bx-trash me-1"></i> Delete
                                        </button>
                                        @endif
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php $sno++; ?>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <!--/ Hoverable Table rows -->
    </div>
</div>

@endsection

@section('admin-custom-js')
<script>
    $("#table").DataTable();
</script>
@endsection
