@extends('admin.layouts.main-layout')
@section('title', 'Manage Sub-Services')
@section('content')
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">
        @if (session('success'))
            <div class="alert alert-success alert-dismissible" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
        <!-- Hoverable Table rows -->
        <div class="card">
            <h5 class="card-header"><span class="text-primary">{{ $single_service->service_name }}</span> -> Manage Sub-Services 
                @if(!empty($enc_parent))
                <a href="{{ route('add.subservice', ["service" => $enc_service, "parent" => $enc_parent]) }}" class="btn rounded-pill btn-icon btn-outline-primary float-end" style="font-size: 1.7em;">+</span></a>
                    @if(!empty($super_parent))
                    <span class="float-end me-2"><a href="{{ route('get.subservices', ["service" => $enc_service, "parent" => $super_parent]) }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span>
                    @else
                    <span class="float-end me-2"><a href="{{ route('get.subservices', $enc_service) }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span>
                    @endif
                    <a href="{{ route('get.subservices.page', ["service" => $enc_service, "parent" => $enc_parent]) }}" class="btn btn-primary float-end me-2">Sub-Services Sequence</a>
                @else
                <a href="{{ route('add.subservice', $enc_service) }}" class="btn rounded-pill btn-icon btn-outline-primary float-end" style="font-size: 1.7em;">+</span></a>
                <span class="float-end me-2"><a href="{{ route('manage_services') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span>
                <a href="{{ route('get.subservices.page', $enc_service) }}" class="btn btn-primary float-end me-2">Sub-Services Sequence</a>
                @endif
            </h5>
            <div class="table-responsive text-nowrap px-4 pb-4">
                <table id="table" class="table table-hover">
                    <thead>
                        <tr>
                            <th>S. No.</th>
                            <th>Service Name & Sections</th>
                            <th>All Sub-Services</th>
                            <th>Service Position</th>
                            <th>Client Service URLs</th>
                            @if($service_templates->isNotEmpty())
                            <th>Apply Template</th>
                            @endif
                            @if(($single_service->service_name == 'Individual Tax') || ($single_service->service_name == 'Business Registration'))
                            <th>Visibility</th>
                            @endif
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        <?php $sno = 1; ?>
                        @foreach($subServicesData as $sub_services)
                        <tr>
                            <td><?= $sno; ?>.</td>
                            <td>
                                <a href="{{ route('get.subservice.sections', $sub_services->encrypted_id) }}">
                                    <strong>{{ $sub_services->service_name }}</strong>
                                </a>
                            </td>
                            <td>
                                <a href="{{ route('get.subservices', ["service" => $enc_service, "parent" => $sub_services->encrypted_id]) }}" class="btn btn-sm btn-info">
                                    <strong>{{ $sub_services->service_name }}</strong>
                                </a>
                            </td>
                            <td>{{ $sub_services->position_order }}</td>
                            <td>
                                @if(!empty($single_subservice))
                                <a href="{{ route('single.subservice', ["service_url" => $single_service->service_url, "parent_url" => $single_subservice->service_url, "subservice_url" => $sub_services->service_url]) }}">
                                    <small><strong>{{ $sub_services->service_name }}</strong></small>
                                </a>
                                @else
                                <a href="{{ route('single.subservice', ["service_url" => $single_service->service_url, "parent_url" => $sub_services->service_url]) }}">
                                    <small><strong>{{ $sub_services->service_name }}</strong></small>
                                </a>
                                @endif
                            </td>
                            @if($service_templates->isNotEmpty())
                            <td>
                                <select onchange="change_template('<?= $model; ?>', <?= $sno; ?>, '<?= $sub_services->encrypted_id; ?>');" id="template_<?= $sno; ?>" class="form-select form-select-sm" style="width: 300px">
                                    @foreach($service_templates as $service_template)
                                        @if($single_service->service_template == $service_template->service_template)
                                            <option value="{{ $service_template->service_template }}" <?= (($sub_services->service_template) == $service_template->service_template ? 'selected' : ''); ?>>
                                                @php
                                                    echo strtoupper($service_template->service_name." (Default Template)");
                                                @endphp
                                            </option>
                                        @else
                                            <option value="{{ $service_template->service_template }}" <?= (($sub_services->service_template) == $service_template->service_template ? 'selected' : ''); ?>>
                                                @php
                                                    echo strtoupper($service_template->service_name);
                                                @endphp
                                            </option>
                                        @endif
                                    @endforeach
                                </select>
                                <div class="text-danger" id="template_error_<?= $sno; ?>"></div>
                            </td>
                            @endif
                            @if($single_service->service_name == 'Individual Tax')
                            <td>
                                <select onchange="change_visibility('<?= $model; ?>', <?= $sno; ?>, '<?= $sub_services->encrypted_id; ?>');" id="visibility<?= $sno; ?>" class="form-select form-select-sm" style="width: 150px">
                                    <option value="first_section" <?= (($sub_services->visibility) == 'first_section' ? 'selected' : ''); ?>>FIRST SECTION</option>
                                    <option value="last_section" <?= (($sub_services->visibility) == 'last_section' ? 'selected' : ''); ?>>LAST SECTION</option>
                                    <option value="none" <?= (($sub_services->visibility) == 'none' ? 'selected' : ''); ?>>NONE</option>
                                </select>
                                <div class="text-danger" id="visibility_error<?= $sno; ?>"></div>
                            </td>
                            @elseif($single_service->service_name == 'Business Registration')
                            <td>
                                <select onchange="change_visibility('<?= $model; ?>', <?= $sno; ?>, '<?= $sub_services->encrypted_id; ?>');" id="visibility<?= $sno; ?>" class="form-select form-select-sm" style="width: 150px">
                                    <option value="first_section" <?= (($sub_services->visibility) == 'first_section' ? 'selected' : ''); ?>>FIRST SECTION</option>
                                    <option value="second_section" <?= (($sub_services->visibility) == 'second_section' ? 'selected' : ''); ?>>SECOND SECTION</option>
                                    <option value="last_section" <?= (($sub_services->visibility) == 'last_section' ? 'selected' : ''); ?>>LAST SECTION</option>
                                    <option value="none" <?= (($sub_services->visibility) == 'none' ? 'selected' : ''); ?>>NONE</option>
                                </select>
                                <div class="text-danger" id="visibility_error<?= $sno; ?>"></div>
                            </td>
                            @endif
                            <td>
                                <div class="form-check form-switch mb-2">
                                    <input class="form-check-input status_button" onclick="change_status('<?= $model; ?>', <?= $sno; ?>, '<?= $sub_services->encrypted_id; ?>');" type="checkbox" id="status<?= $sno; ?>" <?= $sub_services->status == 'active' ? 'checked' : ''; ?> />
                                </div>
                            </td>
                            <td>
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="{{ route('edit.subservice', ["service" => $enc_service, "subservice" => $sub_services->encrypted_id]) }}" ><i class="bx bx-edit-alt me-1"></i> Edit</a>
                                        <button class="dropdown-item" onclick="delete_item('<?= $model; ?>', '<?= $sub_services->encrypted_id; ?>');" >
                                            <i class="bx bx-trash me-1"></i> Delete
                                        </button>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php $sno++; ?>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <!--/ Hoverable Table rows -->
    </div>
</div>
@endsection
@section('admin-custom-js')
<script>
    $("#table").DataTable();
</script>

<script>
    function change_template(model, sno, encrypted_id) {
        $("#template_error_"+sno).html("");
        if(sno == "" || sno == 0 || sno == undefined || sno == null) {
            $("#template_error_"+sno).html("Template is required!");
            return false;
        }

        let token = '{{ csrf_token() }}';
        let template = $("#template_"+sno).val();
        $("#template_" + sno).attr('disabled', true);
        $.ajax({
            url: "{{ route('change.template') }}",
            data: {'_token': token, 'model': model, 'template': template, 'encrypted_id': encrypted_id},
            type: "POST",
            dataType: 'json',
            success: function(result) {
                if(result.status == 'done') {
                    Swal.fire({
                        icon: "success",
                        title: result.message,
                        showConfirmButton: false,
                        timer: 1500
                    });
                    setTimeout(function() {
                        $("#template_" + sno).attr('disabled', false);
                    }, 1500);
                }
                else {
                    Swal.fire({
                        icon: "error",
                        title: result.message,
                        showConfirmButton: false,
                        timer: 1500
                    });
                }
            }
        });
    }
</script>
@endsection