@extends('admin.layouts.main-layout')
@section('title', "Edit Profile")

@section('content')
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Account Settings /</span> Account</h4>
        <div class="row">
            <div class="col-md-12">
                <form id="profile_form_data" method="POST" enctype="multipart/form-data" onsubmit="return form_fields_check();" action="{{ route('edit.profile') }}">
                    @csrf
                    @if (session('success'))
                    <div class="alert alert-success alert-dismissible" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @elseif (session('error'))
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif
                    <div class="card mb-4">
                        <h5 class="card-header">Profile Details</h5>
                        <!-- Account -->
                        <div class="card-body">
                            <div class="d-flex align-items-start align-items-sm-center gap-4">
                                <img src="{{ asset($profile->image) }}" alt="User_Avatar" class="d-block rounded" height="100" width="100" id="uploadedProfile" />
                                <div class="button-wrapper">
                                    <label for="uploadProfile" class="btn btn-primary me-2 mb-4" tabindex="0">
                                        <span class="d-none d-sm-block">Upload New Profile Image</span>
                                        <i class="bx bx-upload d-block d-sm-none"></i>
                                        <input type="file" name="profile_image" id="uploadProfile" class="account-file-input" hidden accept="image/png, image/jpeg, image/jpg" />
                                    </label>

                                    <p class="text-muted mb-0">Allowed JPG, JPEG or PNG.</p>
                                </div>
                            </div>
                        </div>
                        <hr class="my-0" />
                        <div class="card-body">
                            <div class="row">
                                <div class="mb-3 col-md-6">
                                    <label for="firstName" class="form-label">First Name*</label>
                                    <input class="form-control" type="text" id="firstName" name="firstName" placeholder="First" value="{{ $profile->first_name }}" required />
                                    <div id="firstName_error" class="text-danger"></div>
                                    @error('firstName')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="mb-3 col-md-6">
                                    <label for="lastName" class="form-label">Last Name</label>
                                    <input class="form-control" type="text" name="lastName" value="{{ $profile->last_name }}" id="lastName" placeholder="Last" />
                                </div>
                                <div class="mb-3 col-md-6">
                                    <label for="email" class="form-label">E-Mail*</label>
                                    <input class="form-control" type="email" id="email" value="{{ $profile->email }}" name="email" placeholder="abc123@example.com" required />
                                    <div id="email_error" class="text-danger"></div>
                                    @error('email')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="mb-3 col-md-6">
                                    <label class="form-label" for="phone">Phone Number*</label>
                                    <div class="input-group input-group-merge">
                                        <!-- <span class="input-group-text">US (+1)</span> -->
                                        <input type="text" id="phone" name="phone" class="form-control" value="{{ $profile->phone }}" placeholder="123 456 7890" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" minlength="10" maxlength="10" required />
                                    </div>
                                    <div id="phone_error" class="text-danger"></div>
                                    @error('phone')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="mt-2">
                                <input type="submit" value="Update Profile" class="btn btn-primary me-2" />
                            </div>
                        </div>
                        <!-- /Account -->
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- / Content -->

    <!-- Footer -->
    <?php 
    
    // include "include/footer.php";
    
    ?>
    <!-- / Footer -->

    <div class="content-backdrop fade"></div>
</div>
<!-- Content wrapper -->

<script>

    function form_fields_check() {

        let errors = 0;
        let firstName = $("#firstName").val();
        let email = $("#email").val();
        let phone = $("#phone").val();

        $("#firstName_error").html("");
        $("#email_error").html("");
        $("#phone_error").html("");
        if(firstName == "" || firstName == undefined || firstName == null) {

            $("#firstName_error").html("First Name is required!");
            errors += 1;
        }

        if(email == '' || email == undefined || email == null) {

            $("#email_error").html("E-Mail is required!");
            errors += 1;
        }

        if(phone == '' || phone == undefined || phone == null) {

            $("#phone_error").html("Phone is required!");
            errors += 1;
        }

        if(errors > 0) {

            return false;
        }
    }

</script>

@endsection
