@extends('admin.layouts.main-layout')
<?php
if ($currentPage === 'assignment_template') {
    $title = 'Edit Assignment Template';
    $template = $assignment_template;
} elseif ($currentPage === 'project_template') {
    $title = 'Edit Project Template';
    $template = $project_template;
} elseif ($currentPage === 'guess_paper_template') {
    $title = 'Edit Guess Paper Template';
    $template = $guess_paper_template;
}

?>

@section('title', $title)

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form
                action="{{ $currentPage === 'assignment_template' ? route('manage.assignment.template') : route('manage.project.template') }}"
                method="POST" enctype="multipart/form-data">
                @csrf
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?></h5>
                <div class="row">
                    <div class="col-12">
                        @if (session('success'))
                            <div class="alert alert-success alert-dismissible" role="alert">
                                {{ session('success') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @elseif (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-12 mb-3">
                                        <label for="short_description" class="col-form-label">Short Description</label>
                                        <textarea id="short_description" name="short_description" class="form-control" placeholder="Enter Short Description">{{ htmlspecialchars_decode($template->short_description) }}</textarea>
                                        <p class="form-text" style="color: #000000; font-weight: bold;">
                                            <span style="color: #d63384; font-weight: bold;">Use Variable:</span>
                                            <strong>{ CODE }</strong>, <strong>{ SUBJECT_NAME }</strong>,
                                            <strong>{ SESSIONS }</strong>, <strong>{ LANGUAGES }</strong>
                                        </p>
                                    </div>
                                    <div class="col-12 mb-3">
                                        <label for="download_info" class="col-form-label">Download Information</label>
                                        <textarea id="download_info" name="download_info" class="form-control" placeholder="Enter Download Information">{{ htmlspecialchars_decode($template->download_info) }}</textarea>
                                        <p class="form-text" style="color: #000000; font-weight: bold;">
                                            <span style="color: #d63384; font-weight: bold;">Use Variable:</span>
                                            <strong>{ CODE }</strong>, <strong>{ SUBJECT_NAME }</strong>,
                                            <strong>{ SESSIONS }</strong>, <strong>{ LANGUAGES }</strong>
                                        </p>
                                    </div>
                                    <div class="col-12 mb-3">
                                        <label for="description" class="col-form-label">Description</label>
                                        <textarea id="description" name="description" class="form-control" placeholder="Enter Description">{{ htmlspecialchars_decode($template->description) }}</textarea>
                                        <p class="form-text" style="color: #000000; font-weight: bold;">
                                            <span style="color: #d63384; font-weight: bold;">Use Variable:</span>
                                            <strong>{ CODE }</strong>, <strong>{ SUBJECT_NAME }</strong>,
                                            <strong>{ SESSIONS }</strong>, <strong>{ LANGUAGES }</strong>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <label for="cover_page_info" class="col-form-label">Cover Page Information</label>
                                        <textarea id="cover_page_info" name="cover_page_info" class="form-control" placeholder="Enter Cover Page Info">{{ htmlspecialchars_decode($template->cover_page_info) }}</textarea>
                                        <p class="form-text" style="color: #000000; font-weight: bold;">
                                            <span style="color: #d63384; font-weight: bold;">Use Variable:</span>
                                            <strong>{ CODE }</strong>, <strong>{ SUBJECT_NAME }</strong>,
                                            <strong>{ SESSIONS }</strong>, <strong>{ LANGUAGES }</strong>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="demo-inline-spacing">
                            <input type="submit" value="Update Template" class="btn btn-primary" />
                        </div>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>

@endsection
