@extends('admin.layouts.main-layout')
<?php if (!empty($testimonial->encrypted_id)) {
    $title = 'Edit Testimonial';
} else {
    $title = 'Add Testimonial';
}
?>
@section('title', $title)
@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form
                action="{{ !empty($testimonial->encrypted_id) ? route('edit.testimonial', $testimonial->encrypted_id) : route('add.testimonial') }}"
                method="POST" enctype="multipart/form-data">
                @csrf
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="{{ route('manage.testimonials') }}"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-12">
                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <label for="client_name" class="col-form-label">Client Name</label>
                                        <input type="text" class="form-control" id="client_name" name="client_name"
                                            value="{{ !empty($testimonial->encrypted_id) ? $testimonial->client_name : '' }}"
                                            placeholder="Enter Name" />
                                        @error('client_name')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="review_date" class="col-form-label">Client Review Date</label>
                                        <input type="date" class="form-control" id="review_date" name="review_date"
                                            value="{{ !empty($testimonial->encrypted_id) ? date('Y-m-d', strtotime($testimonial->review_date)) : '' }}"
                                            placeholder="Select Date" />
                                    </div>
                                    <div class="col-6">
                                        <label for="rating_quantity" class="col-form-label">Client Rating</label>
                                        <input type="text" class="form-control" id="rating_quantity"
                                            name="rating_quantity"
                                            value="{{ !empty($testimonial->encrypted_id) ? $testimonial->rating_quantity : '' }}"
                                            placeholder="Enter Rating Quantity" />
                                        @error('rating_quantity')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="client_designation" class="col-form-label">Client Designation</label>
                                        <input type="text" class="form-control" id="client_designation"
                                            name="client_designation"
                                            value="{{ !empty($testimonial->encrypted_id) ? $testimonial->client_designation : '' }}"
                                            placeholder="Enter Designation" />
                                        @error('client_designation')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="client_city" class="col-form-label">City (Address)</label>
                                        <input type="text" class="form-control" id="client_city" name="client_city"
                                            value="{{ !empty($testimonial->encrypted_id) ? $testimonial->client_city : '' }}"
                                            placeholder="Enter City Name" />
                                        @error('client_city')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-12">
                                        <label for="description" class="col-form-label">Description</label>
                                        <textarea name="description" id="description" cols="30" rows="5" class="form-control"
                                            placeholder="Enter Description">{{ !empty($testimonial->encrypted_id) ? htmlspecialchars_decode($testimonial->description) : '' }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-body row">
                                <div class="col-12">
                                    <label for="client_image" class="col-form-label">Client Image</label>
                                    @if (!empty($testimonial->encrypted_id) && !empty($testimonial->client_image))
                                        <div class="my-3">
                                            <img src="{{ asset($testimonial->client_image) }}" alt="Client_Image"
                                                class="rounded" height="50px" width="50px">
                                        </div>
                                    @endif
                                    <input class="form-control" type="file" id="client_image" name="client_image"
                                        accept="image/*" />
                                </div>
                            </div>
                        </div>
                        <div class="demo-inline-spacing">
                            <input type="submit"
                                value="{{ !empty($testimonial->encrypted_id) ? 'Update Testimonial' : 'Add Testimonial' }}"
                                class="btn btn-primary" />
                            <a href="{{ route('manage.testimonials') }}" class="btn btn-outline-secondary">Back</a>
                        </div>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>
@endsection
