<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Invoice - {{ $invoice->invoice_number }}</title>

    <style>
        body {
            font-family: Arial, sans-serif;
            color: #333;
            margin: 0;
            padding: 0;
            font-size: 13px;
        }

        .container {
            width: 100%;
            padding: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 25px;
        }

        .header h1 {
            margin: 0;
            color: #0d6efd;
        }

        .section-title {
            font-weight: bold;
            margin: 20px 0 10px;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }

        td,
        th {
            padding: 8px;
            vertical-align: top;
        }

        .label {
            font-weight: bold;
            width: 150px;
        }

        .items th {
            background: #f2f2f2;
            border: 1px solid #ddd;
        }

        .items td {
            border: 1px solid #ddd;
        }

        .left {
            text-align: left;
        }

        .right {
            text-align: right;
        }

        .total-box {
            width: 300px;
            float: right;
            margin-top: 10px;
        }

        .total-box td {
            padding: 6px;
        }

        .footer {
            text-align: center;
            margin-top: 50px;
            font-size: 12px;
            color: #777;
        }

        .badge {
            display: inline-block;
            padding: 4px 8px;
            font-size: 12px;
            border-radius: 4px;
        }

        .paid {
            background: #d1e7dd;
            color: #0f5132;
        }

        .unpaid {
            background: #f8d7da;
            color: #842029;
        }
    </style>
</head>

<body>
    <div class="container">

        <!-- Header -->
        <div class="header">
            <h1>{{ config('app.name') }}</h1>
            <p>INVOICE</p>
        </div>

        <!-- Invoice Info -->
        <table>
            <tr>
                <td class="label">Invoice #</td>
                <td>{{ $invoice->invoice_number }}</td>

                <td class="label">Invoice Date</td>
                <td>{{ $invoice->created_at->format('d M Y') }}</td>
            </tr>
            <tr>
                <td class="label">Order #</td>
                <td>{{ $order->order_number }}</td>

                <td class="label">Payment Mode</td>
                <td>{{ strtoupper($invoice->payment_mode) }}</td>
            </tr>
            <tr>
                <td class="label">Payment Status</td>
                <td colspan="3">
                    <span class="badge {{ $invoice->status === 'paid' ? 'paid' : 'unpaid' }}">
                        {{ strtoupper($invoice->status) }}
                    </span>
                </td>
            </tr>

            @if ($transaction)
                <tr>
                    <td class="label">Transaction ID</td>
                    <td colspan="3">{{ $transaction->gateway_transaction_id }}</td>
                </tr>
            @endif
        </table>

        {{-- <!-- Customer Details -->
        <div class="section-title">Billing Details</div>
        <table>
            <tr>
                <td class="label">Name</td>
                <td>{{ $customer->first_name }} {{ $customer->last_name }}</td>
            </tr>
            <tr>
                <td class="label">Email</td>
                <td>{{ $customer->email }}</td>
            </tr>
            <tr>
                <td class="label">Phone</td>
                <td>{{ $order->billing_details['phone'] ?? '-' }}</td>
            </tr>
            <tr>
                <td class="label">Address</td>
                <td>
                    {{ $order->billing_details['address'] ?? '' }},
                    {{ $order->billing_details['state'] ?? '' }},
                    {{ $order->billing_details['country'] ?? '' }} -
                    {{ $order->billing_details['zip'] ?? '' }}
                </td>
            </tr>
        </table> --}}

        {{-- <!-- Shipping Details -->
        <div class="section-title">Shipping Details</div>
        <table>
            <tr>
                <td class="label">Name</td>
                <td>{{ $order->shipping_details['firstName'] ?? '' }} {{ $order->shipping_details['lastName'] ?? '' }}
                </td>
            </tr>
            <tr>
                <td class="label">Address</td>
                <td>
                    {{ $order->shipping_details['address'] ?? '' }},
                    {{ $order->shipping_details['state'] ?? '' }},
                    {{ $order->shipping_details['country'] ?? '' }} -
                    {{ $order->shipping_details['zip'] ?? '' }}
                </td>
            </tr>
        </table> --}}

        <!-- Items -->
        <div class="section-title">Order Items</div>
        <table class="items">
            <thead>
                <tr>
                    <th class="left">Description</th>
                    <th class="right">Price</th>
                    <th class="right">Qty</th>
                    <th class="right">Total</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($order->items as $item)
                    <tr>
                        <td>
                            {{ 'Course Code: ' . $item->course->course_code ?? 'Course' }}
                            @if ($item->assignment_id)
                                <br><small>{{ 'Assignment Code: ' . $item->assignment->assignment_code }}</small>
                            @elseif($item->project_id)
                                <br><small>{{ 'Project Code: ' . $item->project->project_code }}</small>
                            @endif
                        </td>
                        <td class="right">{{ number_format($item->price, 2) }}</td>
                        <td class="right">{{ $item->quantity }}</td>
                        <td class="right">{{ number_format($item->total, 2) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        <!-- Totals -->
        <table class="total-box">
            <tr>
                <td>Subtotal</td>
                <td class="right">{{ number_format($order->subtotal, 2) }}</td>
            </tr>
            <tr>
                <td><strong>Total</strong></td>
                <td class="right"><strong>{{ number_format($invoice->amount, 2) }} {{ $invoice->currency }}</strong>
                </td>
            </tr>
        </table>

        <div style="clear: both;"></div>

        <!-- Footer -->
        <div class="footer">
            @if ($invoice->status === 'paid')
                <p>Thank you for your payment!</p>
            @else
                <p><strong>Payment pending.</strong> Please pay at the time of delivery.</p>
            @endif
            <p>{{ config('app.name') }} | {{ url('/') }}</p>
        </div>

    </div>
</body>

</html>
