<?php $__env->startSection('title', 'Manage Assignments'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php elseif(session('error')): ?>
                <div class="alert alert-danger alert-dismissible" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            <!-- Hoverable Table rows -->
            <div class="card">
                <h5 class="card-header">Manage Assignments
                    <span class="float-end">
                        <a href="<?php echo e(route('add.assignment')); ?>"
                            class="btn rounded-pill btn-icon btn-outline-primary float-end ms-2"
                            style="font-size: 1.7em;">+</a>
                        
                    </span>
                </h5>
                <div class="table-responsive text-nowrap px-4 pb-4">
                    <table id="assignments_table" class="table table-hover">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th>Subject Code (Subject Name)</th>
                                <th>Assignment Type</th>
                                <th>Assignment Code</th>
                                <th>Assignment Title</th>
                                <th>Assignment Position</th>
                                <th>Assignment Image</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0"></tbody>
                    </table>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-custom-js'); ?>
    <script>
        $('#assignments_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "<?php echo e(route('manage.assignments.data')); ?>",

            pageLength: 25,
            lengthMenu: [10, 25, 50, 100],
            autoWidth: false,

            columns: [{
                    data: "id"
                },
                {
                    data: "subject"
                },
                {
                    data: "assignment_type"
                },
                {
                    data: "assignment_code"
                },
                {
                    data: "assignment_title"
                },
                {
                    data: "position_order"
                },
                {
                    data: "assignment_image"
                },
                {
                    data: "status"
                },
                {
                    data: "action"
                },
            ],

            columnDefs: [{
                    width: "80px",
                    targets: 0
                },
                {
                    width: "220px",
                    targets: 1
                }, // Subject
                {
                    width: "120px",
                    targets: 2
                }, // Assignment Type
                {
                    width: "120px",
                    targets: 3
                }, // Assignment Code
                {
                    width: "250px",
                    targets: 4
                }, // Assignment Title
                {
                    width: "100px",
                    targets: 5
                }, // Position
                {
                    width: "120px",
                    targets: 6
                }, // Image
                {
                    width: "90px",
                    targets: 7
                }, // Status
                {
                    width: "90px",
                    targets: 8
                } // Actions
            ],
        });

        
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\github-backend\excelsius-ignou-api\resources\views/admin/manage_assignments.blade.php ENDPATH**/ ?>