<?php $__env->startSection('title', 'Manage Courses'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php elseif(session('error')): ?>
                <div class="alert alert-danger alert-dismissible" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            <!-- Hoverable Table rows -->
            <div class="card">
                <h5 class="card-header">
                    Manage Courses
                    <a href="<?php echo e(route('add.course')); ?>" class="btn rounded-pill btn-icon btn-outline-primary float-end"
                        style="font-size: 1.7em;">+</a>
                </h5>

                
                <ul class="nav nav-tabs px-4" role="tablist">
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item">
                            <button class="nav-link <?php echo e($index == 0 ? 'active' : ''); ?>" data-bs-toggle="tab"
                                data-bs-target="#cat<?php echo e($category->id); ?>" type="button" role="tab">
                                <?php echo e($category->category_label); ?>

                            </button>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>

                <div class="tab-content p-4">

                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="tab-pane fade <?php echo e($index == 0 ? 'show active' : ''); ?>" id="cat<?php echo e($category->id); ?>"
                            role="tabpanel">

                            <?php if($category->courses->count()): ?>
                                <div class="table-responsive text-nowrap">
                                    <table class="table table-hover category-table">
                                        <thead>
                                            <tr>
                                                <th>S. No.</th>
                                                
                                                <th>Course Code</th>
                                                <th>Course Name</th>
                                                <th>Course Headline</th>
                                                <th>Course Duration</th>
                                                <th>Course Position</th>
                                                <th>Course Icon</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            <?php $__currentLoopData = $category->courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($i + 1); ?>.</td>

                                                    

                                                    <td><strong><?php echo e($course->course_code); ?></strong></td>
                                                    <td><?php echo e($course->course_name); ?></td>
                                                    <td><?php echo e($course->course_headline); ?></td>
                                                    <td><?php echo e($course->course_duration); ?> Year(s)</td>
                                                    <td><?php echo e($course->position_order); ?></td>

                                                    <td>
                                                        <?php if($course->course_icon): ?>
                                                            <i class="fa-solid <?php echo e($course->course_icon); ?>"></i>
                                                        <?php endif; ?>
                                                    </td>

                                                    <td>
                                                        <div class="form-check form-switch mb-2">
                                                            <input class="form-check-input status_button"
                                                                onclick="change_status('<?php echo e($model); ?>', <?php echo e($i + 1); ?>, '<?php echo e($course->encrypted_id); ?>');"
                                                                type="checkbox"
                                                                id="status<?php echo e($category->id); ?><?php echo e($i); ?>"
                                                                <?php echo e($course->status == 'active' ? 'checked' : ''); ?> />
                                                        </div>
                                                    </td>

                                                    <td>
                                                        <div class="dropdown">
                                                            <button type="button"
                                                                class="btn p-0 dropdown-toggle hide-arrow"
                                                                data-bs-toggle="dropdown">
                                                                <i class="bx bx-dots-vertical-rounded"></i>
                                                            </button>

                                                            <div class="dropdown-menu">
                                                                <a class="dropdown-item"
                                                                    href="<?php echo e(route('edit.course', $course->encrypted_id)); ?>">
                                                                    <i class="bx bx-edit-alt me-1"></i> Edit
                                                                </a>

                                                                <button class="dropdown-item"
                                                                    onclick="delete_item('<?php echo e($model); ?>', '<?php echo e($course->encrypted_id); ?>');">
                                                                    <i class="bx bx-trash me-1"></i> Delete
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </td>

                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <p class="text-muted mb-0">No courses in this category yet.</p>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-custom-js'); ?>
    <script>
        $(".category-table").DataTable();

        
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\github-backend\excelsius-ignou-api\resources\views/admin/manage_courses.blade.php ENDPATH**/ ?>