<?php $__env->startPush('custom-js'); ?>
    <script>
        $(document).ready(function() {
            const partialDownloadedFilesChartWrapper = $('#partialDownloadedFilesChartWrapper');
            const partialDownloadedFilesChartEl = document.querySelector('#partialDownloadedFilesChart');

            if (!partialDownloadedFilesChartEl) return;

            $.ajax({
                url: "<?php echo e(route('partially.downloaded.chart.data')); ?>",
                method: "GET",
                dataType: "json",
                success: function(response) {
                    const {
                        months,
                        series,
                        total
                    } = response;
                    const currentYear = new Date().getFullYear();
                    partialDownloadedFilesChartEl.innerHTML = '';

                    $("#partialDownloadedFilesCount").text(total);

                    const partialDownloadedFilesChartConfig = {
                        series: [{
                            name: 'Partially Downloaded Files',
                            data: series
                        }],
                        chart: {
                            height: 215,
                            parentHeightOffset: 0,
                            parentWidthOffset: 0,
                            toolbar: {
                                show: false
                            },
                            type: 'area'
                        },
                        dataLabels: {
                            enabled: false
                        },
                        stroke: {
                            width: 2,
                            curve: 'smooth'
                        },
                        legend: {
                            show: false
                        },
                        markers: {
                            size: 6,
                            colors: 'transparent',
                            strokeColors: 'transparent',
                            strokeWidth: 4,
                            discrete: [{
                                fillColor: '#fff',
                                seriesIndex: 0,
                                dataPointIndex: series.length - 1,
                                strokeColor: '#ffab00',
                                strokeWidth: 2,
                                size: 6,
                                radius: 8
                            }],
                            hover: {
                                size: 7
                            }
                        },
                        colors: ['#ffab00'],
                        fill: {
                            type: 'gradient',
                            gradient: {
                                shadeIntensity: 0.6,
                                opacityFrom: 0.5,
                                opacityTo: 0.25,
                                stops: [0, 95, 100]
                            }
                        },
                        grid: {
                            borderColor: '#e0e0e0',
                            strokeDashArray: 3,
                            padding: {
                                top: -20,
                                bottom: 10,
                                left: -10,
                                right: 8
                            }
                        },
                        xaxis: {
                            categories: months,
                            axisBorder: {
                                show: false
                            },
                            axisTicks: {
                                show: false
                            },
                            labels: {
                                show: true,
                                style: {
                                    fontSize: '13px',
                                    colors: '#6c757d'
                                }
                            }
                        },
                        yaxis: {
                            labels: {
                                show: false
                            },
                            min: 0
                        }
                    };

                    const partialDownloadedFilesChart = new ApexCharts(
                        partialDownloadedFilesChartEl,
                        partialDownloadedFilesChartConfig);

                    partialDownloadedFilesChart.render().then(() => {
                        // ✅ Append year label outside SVG area
                        const yearLabel = $('<div>', {
                            text: currentYear,
                            css: {
                                textAlign: 'center',
                                marginTop: '4px',
                                color: '#6c757d',
                                fontSize: '13px',
                                fontWeight: 500
                            }
                        });

                        // Place it after the chart container
                        $(partialDownloadedFilesChartEl).after(yearLabel);
                    });
                },
                error: function(xhr) {
                    console.error('Failed to load Downloaded Chart:', xhr);
                }
            });
        });
    </script>

    
<?php $__env->stopPush(); ?>
<?php /**PATH D:\github-backend\excelsius-ignou-api\resources\views/admin/ajax/partially-downloaded-files-chart.blade.php ENDPATH**/ ?>