
<?php
if ($currentPage === 'assignment_template') {
    $title = 'Edit Assignment Template';
    $template = $assignment_template;
} else {
    $title = 'Edit Project Template';
    $template = $project_template;
}

?>

<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form
                action="<?php echo e($currentPage === 'assignment_template' ? route('manage.assignment.template') : route('manage.project.template')); ?>"
                method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?></h5>
                <div class="row">
                    <div class="col-12">
                        <?php if(session('success')): ?>
                            <div class="alert alert-success alert-dismissible" role="alert">
                                <?php echo e(session('success')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        <?php elseif(session('error')): ?>
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                <?php echo e(session('error')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        <?php endif; ?>
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-12 mb-3">
                                        <label for="short_description" class="col-form-label">Short Description</label>
                                        <textarea id="short_description" name="short_description" class="form-control" placeholder="Enter Short Description"><?php echo e(htmlspecialchars_decode($template->short_description)); ?></textarea>
                                        <p class="form-text" style="color: #000000; font-weight: bold;">
                                            <span style="color: #d63384; font-weight: bold;">Use Variable:</span>
                                            <strong>{ ASSIGNMENT_CODE }</strong>, <strong>{ SUBJECT_NAME }</strong>,
                                            <strong>{ SESSIONS }</strong>, <strong>{ LANGUAGES }</strong>
                                        </p>
                                    </div>
                                    <div class="col-12 mb-3">
                                        <label for="download_info" class="col-form-label">Download Information</label>
                                        <textarea id="download_info" name="download_info" class="form-control" placeholder="Enter Download Information"><?php echo e(htmlspecialchars_decode($template->download_info)); ?></textarea>
                                        <p class="form-text" style="color: #000000; font-weight: bold;">
                                            <span style="color: #d63384; font-weight: bold;">Use Variable:</span>
                                            <strong>{ ASSIGNMENT_CODE }</strong>, <strong>{ SUBJECT_NAME }</strong>,
                                            <strong>{ SESSIONS }</strong>, <strong>{ LANGUAGES }</strong>
                                        </p>
                                    </div>
                                    <div class="col-12 mb-3">
                                        <label for="description" class="col-form-label">Description</label>
                                        <textarea id="description" name="description" class="form-control" placeholder="Enter Description"><?php echo e(htmlspecialchars_decode($template->description)); ?></textarea>
                                        <p class="form-text" style="color: #000000; font-weight: bold;">
                                            <span style="color: #d63384; font-weight: bold;">Use Variable:</span>
                                            <strong>{ ASSIGNMENT_CODE }</strong>, <strong>{ SUBJECT_NAME }</strong>,
                                            <strong>{ SESSIONS }</strong>, <strong>{ LANGUAGES }</strong>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <label for="cover_page_info" class="col-form-label">Cover Page Information</label>
                                        <textarea id="cover_page_info" name="cover_page_info" class="form-control" placeholder="Enter Cover Page Info"><?php echo e(htmlspecialchars_decode($template->cover_page_info)); ?></textarea>
                                        <p class="form-text" style="color: #000000; font-weight: bold;">
                                            <span style="color: #d63384; font-weight: bold;">Use Variable:</span>
                                            <strong>{ ASSIGNMENT_CODE }</strong>, <strong>{ SUBJECT_NAME }</strong>,
                                            <strong>{ SESSIONS }</strong>, <strong>{ LANGUAGES }</strong>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="demo-inline-spacing">
                            <input type="submit" value="Update Template" class="btn btn-primary" />
                        </div>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\github-backend\excelsius-ignou-api\resources\views/admin/template.blade.php ENDPATH**/ ?>