<?php $__env->startSection('title', 'Manage Pages'); ?>

<?php $__env->startSection('content'); ?>
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>
        <!-- Hoverable Table rows -->
        <div class="card">
            <h5 class="card-header">Manage Pages
                <?php if(session()->get('role') == 'superadmin'): ?>
                <a href="<?php echo e(route('add.page')); ?>" class="btn rounded-pill btn-icon btn-outline-primary float-end" style="font-size: 1.7em;">+</span></a>
                <?php endif; ?>
                <a href="<?php echo e(route('get.pages.page')); ?>" class="btn btn-primary float-end me-2">Pages Sequence</a>
            </h5>
            <div class="table-responsive text-nowrap px-4 pb-4">
                <table id="table" class="table table-hover">
                    <thead>
                        <tr>
                            <th>S. No.</th>
                            <th>Page Name</th>
                            <?php if(session()->get('role') == 'superadmin'): ?>
                            <th>Page Position</th>
                            <?php endif; ?>
                            <th>Client Page URLs</th>
                            <th>Visibility</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        <?php $sno = 1; ?>
                        <?php $__currentLoopData = $pagesData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pages): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?= $sno; ?>.</td>
                            <td>
                                <strong><?php echo e($pages->page_name); ?></strong>
                            </td>
                            <?php if(session()->get('role') == 'superadmin'): ?>
                            <td><?php echo e($pages->position_order); ?></td>
                            <?php endif; ?>
                            <?php if(empty($pages->client_page_urls) || $pages->client_page_urls == 'index' || $pages->client_page_urls == 'home') {
                                $client_url = '/';
                            }
                            else {
                                $client_url = '/'.$pages->client_page_urls;
                            }
                            ?>
                            <td>
                                <a href="<?php echo e($client_url); ?>">
                                    <small><strong><?php echo e($pages->header_footer_name); ?></strong></small>
                                </a>
                            </td>
                            <?php if($pages->id != 1 || session('role') == 'superadmin'): ?>
                            <td>
                                <select onchange="change_visibility('<?= $model; ?>', <?= $sno; ?>, '<?= $pages->encrypted_id; ?>');" id="visibility<?= $sno; ?>" class="form-select form-select-sm">
                                    <option value="header" <?= (($pages->visibility) == 'header' ? 'selected' : ''); ?>>HEADER</option>
                                    <option value="footer" <?= (($pages->visibility) == 'footer' ? 'selected' : ''); ?>>FOOTER</option>
                                    <option value="both" <?= (($pages->visibility) == 'both' ? 'selected' : ''); ?>>BOTH</option>
                                    <option value="none" <?= (($pages->visibility) == 'none' ? 'selected' : ''); ?>>NONE</option>
                                </select>
                                <div class="text-danger" id="visibility_error<?= $sno; ?>"></div>
                            </td>
                            <td>
                                <div class="form-check form-switch mb-2">
                                    <input class="form-check-input status_button" onclick="change_status('<?= $model; ?>', <?= $sno; ?>, '<?= $pages->encrypted_id; ?>');" type="checkbox" id="status<?= $sno; ?>" <?= $pages->status == 'active' ? 'checked' : ''; ?> />
                                </div>
                            </td>
                            <?php else: ?>
                            <td></td>
                            <td></td>
                            <?php endif; ?>
                            <td>
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="<?php echo e(route('edit.page', $pages->encrypted_id)); ?>" >
                                            <i class="bx bx-edit-alt me-1"></i> Edit
                                        </a>
                                        <?php if(session()->get('role') == 'superadmin'): ?>
                                        <button class="dropdown-item" onclick="delete_item('<?= $model; ?>', '<?= $pages->encrypted_id; ?>');" >
                                            <i class="bx bx-trash me-1"></i> Delete
                                        </button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php $sno++; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!--/ Hoverable Table rows -->
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-custom-js'); ?>
<script>
    $("#table").DataTable();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\github-backend\excelsius-ignou-api\resources\views/admin/manage_pages.blade.php ENDPATH**/ ?>