<?php $__env->startSection('title', "Edit Profile"); ?>

<?php $__env->startSection('content'); ?>
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Account Settings /</span> Account</h4>
        <div class="row">
            <div class="col-md-12">
                <form id="profile_form_data" method="POST" enctype="multipart/form-data" onsubmit="return form_fields_check();" action="<?php echo e(route('edit.profile')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible" role="alert">
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php elseif(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php endif; ?>
                    <div class="card mb-4">
                        <h5 class="card-header">Profile Details</h5>
                        <!-- Account -->
                        <div class="card-body">
                            <div class="d-flex align-items-start align-items-sm-center gap-4">
                                <img src="<?php echo e(asset($profile->image)); ?>" alt="User_Avatar" class="d-block rounded" height="100" width="100" id="uploadedProfile" />
                                <div class="button-wrapper">
                                    <label for="uploadProfile" class="btn btn-primary me-2 mb-4" tabindex="0">
                                        <span class="d-none d-sm-block">Upload New Profile Image</span>
                                        <i class="bx bx-upload d-block d-sm-none"></i>
                                        <input type="file" name="profile_image" id="uploadProfile" class="account-file-input" hidden accept="image/png, image/jpeg, image/jpg" />
                                    </label>

                                    <p class="text-muted mb-0">Allowed JPG, JPEG or PNG.</p>
                                </div>
                            </div>
                        </div>
                        <hr class="my-0" />
                        <div class="card-body">
                            <div class="row">
                                <div class="mb-3 col-md-6">
                                    <label for="firstName" class="form-label">First Name*</label>
                                    <input class="form-control" type="text" id="firstName" name="firstName" placeholder="First" value="<?php echo e($profile->first_name); ?>" required />
                                    <div id="firstName_error" class="text-danger"></div>
                                    <?php $__errorArgs = ['firstName'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="mb-3 col-md-6">
                                    <label for="lastName" class="form-label">Last Name</label>
                                    <input class="form-control" type="text" name="lastName" value="<?php echo e($profile->last_name); ?>" id="lastName" placeholder="Last" />
                                </div>
                                <div class="mb-3 col-md-6">
                                    <label for="email" class="form-label">E-Mail*</label>
                                    <input class="form-control" type="email" id="email" value="<?php echo e($profile->email); ?>" name="email" placeholder="abc123@example.com" required />
                                    <div id="email_error" class="text-danger"></div>
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="mb-3 col-md-6">
                                    <label class="form-label" for="phone">Phone Number*</label>
                                    <div class="input-group input-group-merge">
                                        <!-- <span class="input-group-text">US (+1)</span> -->
                                        <input type="text" id="phone" name="phone" class="form-control" value="<?php echo e($profile->phone); ?>" placeholder="123 456 7890" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" minlength="10" maxlength="10" required />
                                    </div>
                                    <div id="phone_error" class="text-danger"></div>
                                    <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="mt-2">
                                <input type="submit" value="Update Profile" class="btn btn-primary me-2" />
                            </div>
                        </div>
                        <!-- /Account -->
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- / Content -->

    <!-- Footer -->
    <?php 
    
    // include "include/footer.php";
    
    ?>
    <!-- / Footer -->

    <div class="content-backdrop fade"></div>
</div>
<!-- Content wrapper -->

<script>

    function form_fields_check() {

        let errors = 0;
        let firstName = $("#firstName").val();
        let email = $("#email").val();
        let phone = $("#phone").val();

        $("#firstName_error").html("");
        $("#email_error").html("");
        $("#phone_error").html("");
        if(firstName == "" || firstName == undefined || firstName == null) {

            $("#firstName_error").html("First Name is required!");
            errors += 1;
        }

        if(email == '' || email == undefined || email == null) {

            $("#email_error").html("E-Mail is required!");
            errors += 1;
        }

        if(phone == '' || phone == undefined || phone == null) {

            $("#phone_error").html("Phone is required!");
            errors += 1;
        }

        if(errors > 0) {

            return false;
        }
    }

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\github-backend\excelsius-ignou-api\resources\views/admin/profile-ops.blade.php ENDPATH**/ ?>