<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>New Enquiry Received</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            margin: 0;
            padding: 20px;
        }

        .container {
            max-width: 650px;
            margin: 0 auto;
            background: #ffffff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            padding: 20px 30px;
        }

        h2 {
            color: #333333;
            border-bottom: 2px solid #f1f1f1;
            padding-bottom: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        td {
            padding: 8px 0;
            vertical-align: top;
            color: #555555;
        }

        td:first-child {
            font-weight: bold;
            width: 150px;
        }

        .message {
            margin-top: 20px;
            padding: 15px;
            background: #f6f6f6;
            border-radius: 6px;
            white-space: pre-line;
        }

        .footer {
            margin-top: 25px;
            font-size: 13px;
            color: #888888;
            text-align: center;
        }
    </style>
</head>

<body>
    <div class="container">
        <h2>📩 New Enquiry Received</h2>

        <p>Hello Admin,</p>
        <p>You’ve received a new enquiry from your website. Here are the details:</p>

        <table>
            <tr>
                <td>First Name:</td>
                <td><?php echo e($data['first_name']); ?></td>
            </tr>
            <tr>
                <td>Last Name:</td>
                <td><?php echo e($data['last_name']); ?></td>
            </tr>
            <tr>
                <td>E-Mail:</td>
                <td><a href="mailto: <?php echo e($data['email']); ?>"><?php echo e($data['email']); ?></a></td>
            </tr>
            <tr>
                <td>Phone:</td>
                <td><?php echo e($data['phone']); ?></td>
            </tr>
        </table>

        <?php if(!empty($data['message'])): ?>
            <div class="message">
                <strong>Message:</strong><br>
                <?php echo e($data['message']); ?>

            </div>
        <?php endif; ?>

        <div class="footer">
            <p>This email was sent automatically by <?php echo e(config('app.name', 'MyApp')); ?>.</p>
        </div>
    </div>
</body>

</html>
<?php /**PATH D:\github-backend\excelsius-ignou-api\resources\views/emails/send-enquiry.blade.php ENDPATH**/ ?>